/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FpeDatePart {
    private String value;
    public static final FpeDatePart MONTH = new FpeDatePart("month");
    public static final FpeDatePart DAY = new FpeDatePart("day");
    public static final FpeDatePart YEAR = new FpeDatePart("year");
    private static final Map<String, FpeDatePart> valueMap = new HashMap<String, FpeDatePart>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private FpeDatePart(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FpeDatePart[] values() {
        valueMapLock.lock();
        try {
            FpeDatePart[] fpeDatePartArray = valueMap.values().toArray(new FpeDatePart[valueMap.values().size()]);
            return fpeDatePartArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static FpeDatePart fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                FpeDatePart fpeDatePart = valueMap.get(val);
                return fpeDatePart;
            }
            FpeDatePart newValue = new FpeDatePart(val);
            valueMap.put(val, newValue);
            FpeDatePart fpeDatePart = newValue;
            return fpeDatePart;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("month", MONTH);
        valueMap.put("day", DAY);
        valueMap.put("year", YEAR);
    }
}

