/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.FpeConstraints;
import com.fortanix.sdkms.v1.model.FpeDataPart;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Structure of a simple tokenized portion of a complex tokenization data type.  ***Implementation note: the parser will try to (locally) match as many characters as possible. (See the description of `FpeDataPart` for more information about why this matters.)*** ")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FpeEncryptedPart
extends FpeDataPart {
    @JsonProperty(value="min_length")
    private Integer minLength = null;
    @JsonProperty(value="max_length")
    private Integer maxLength = null;
    @JsonProperty(value="char_set")
    private List<List<String>> charSet = new ArrayList<List<String>>();
    @JsonProperty(value="constraints")
    private FpeConstraints constraints = null;
    @JsonProperty(value="preserve")
    private List<Integer> preserve = null;
    @JsonProperty(value="mask")
    private Object mask = null;

    public FpeEncryptedPart minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @ApiModelProperty(required=true, value="The minimum allowed length for this part (in chars).")
    @JsonProperty(value="min_length")
    public Integer getMinLength() {
        return this.minLength;
    }

    @JsonProperty(value="min_length")
    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public FpeEncryptedPart maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @ApiModelProperty(required=true, value="The maximum allowed length for this part (in chars).")
    @JsonProperty(value="max_length")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @JsonProperty(value="max_length")
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public FpeEncryptedPart charSet(List<List<String>> charSet) {
        this.charSet = charSet;
        return this;
    }

    public FpeEncryptedPart addCharSetItem(List<String> charSetItem) {
        this.charSet.add(charSetItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The character set to use for this part.  Characters should be specified as a list of pairs, where each pair [a, b] (example: ['0', '9']) represents the range of Unicode codepoints from a to b, with both bounds being inclusive. A single character can be represented as [c, c] (example: ['/', '/']).  Ranges should not overlap with each other, and should not contain surrogate codepoints.  *Implementation note: normally, each character is assigned a numeric value for FF1, going in the order specified in the array. For instance, in the character set [['a', 'z'], ['0', '9']], the digits from 0 to 9 DO NOT have their usual numeric values; instead, they correspond to the numerals from 26 to 35 (since they come after the 'a' to 'z' range). Note that for practical purposes, this is largely irrelevant, except when specifying a \"numeric\" character set, which MUST contain exactly the digits from 0 to 9, in order. **(When trying to use numeric constraints, it is best to use [[\"0\", \"9\"]] as the character set.)*** ")
    @JsonProperty(value="char_set")
    public List<List<String>> getCharSet() {
        return this.charSet;
    }

    @JsonProperty(value="char_set")
    public void setCharSet(List<List<String>> charSet) {
        this.charSet = charSet;
    }

    public FpeEncryptedPart constraints(FpeConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="constraints")
    public FpeConstraints getConstraints() {
        return this.constraints;
    }

    @JsonProperty(value="constraints")
    public void setConstraints(FpeConstraints constraints) {
        this.constraints = constraints;
    }

    public FpeEncryptedPart preserve(List<Integer> preserve) {
        this.preserve = preserve;
        return this;
    }

    public FpeEncryptedPart addPreserveItem(Integer preserveItem) {
        if (this.preserve == null) {
            this.preserve = new ArrayList<Integer>();
        }
        this.preserve.add(preserveItem);
        return this;
    }

    @ApiModelProperty(value="The characters to be preserved while encrypting or decrypting. This should either be the string \"all\", or it should be an array of Python-like indices (i.e., where negative indices index from the back of the token portion, with -1 referring to the end of the array). When specifying indices, it is an error to specify indices greater than (min_length - 1) or less than (-min_length). ")
    @JsonProperty(value="preserve")
    public List<Integer> getPreserve() {
        return this.preserve;
    }

    @JsonProperty(value="preserve")
    public void setPreserve(List<Integer> preserve) {
        this.preserve = preserve;
    }

    public FpeEncryptedPart mask(Object mask) {
        this.mask = mask;
        return this;
    }

    @ApiModelProperty(value="The characters to be masked while performing masked decryption. This should either be the string \"all\", or it should be an array of Python-like indices (i.e., where negative indices index from the back of the token portion, with -1 referring to the end of the array). When specifying indices, it is an error to specify indices greater than (min_length - 1) or less than (-min_length). ")
    @JsonProperty(value="mask")
    public Object getMask() {
        return this.mask;
    }

    @JsonProperty(value="mask")
    public void setMask(Object mask) {
        this.mask = mask;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FpeEncryptedPart fpeEncryptedPart = (FpeEncryptedPart)o;
            return Objects.equals(this.minLength, fpeEncryptedPart.minLength) && Objects.equals(this.maxLength, fpeEncryptedPart.maxLength) && Objects.equals(this.charSet, fpeEncryptedPart.charSet) && Objects.equals(this.constraints, fpeEncryptedPart.constraints) && Objects.equals(this.preserve, fpeEncryptedPart.preserve) && Objects.equals(this.mask, fpeEncryptedPart.mask);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minLength, this.maxLength, this.charSet, this.constraints, this.preserve, this.mask);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FpeEncryptedPart {\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    charSet: ").append(this.toIndentedString(this.charSet)).append("\n");
        sb.append("    constraints: ").append(this.toIndentedString(this.constraints)).append("\n");
        sb.append("    preserve: ").append(this.toIndentedString(this.preserve)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }
}

