/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HmgKind {
    private String value;
    public static final HmgKind AWSKMS = new HmgKind("AWSKMS");
    public static final HmgKind AWSCLOUDHSM = new HmgKind("AWSCLOUDHSM");
    public static final HmgKind AZUREKEYVAULT = new HmgKind("AZUREKEYVAULT");
    public static final HmgKind NCIPHER = new HmgKind("NCIPHER");
    public static final HmgKind SAFENET = new HmgKind("SAFENET");
    public static final HmgKind FORTANIX = new HmgKind("FORTANIX");
    public static final HmgKind FORTANIXFIPSCLUSTER = new HmgKind("FORTANIXFIPSCLUSTER");
    private static final Map<String, HmgKind> valueMap = new HashMap<String, HmgKind>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private HmgKind(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HmgKind[] values() {
        valueMapLock.lock();
        try {
            HmgKind[] hmgKindArray = valueMap.values().toArray(new HmgKind[valueMap.values().size()]);
            return hmgKindArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static HmgKind fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                HmgKind hmgKind = valueMap.get(val);
                return hmgKind;
            }
            HmgKind newValue = new HmgKind(val);
            valueMap.put(val, newValue);
            HmgKind hmgKind = newValue;
            return hmgKind;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("AWSKMS", AWSKMS);
        valueMap.put("AWSCLOUDHSM", AWSCLOUDHSM);
        valueMap.put("AZUREKEYVAULT", AZUREKEYVAULT);
        valueMap.put("NCIPHER", NCIPHER);
        valueMap.put("SAFENET", SAFENET);
        valueMap.put("FORTANIX", FORTANIX);
        valueMap.put("FORTANIXFIPSCLUSTER", FORTANIXFIPSCLUSTER);
    }
}

