/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.KeyAttestationResponseAttestationStatement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A key attestation statement")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeyAttestationResponse {
    @JsonProperty(value="authority_chain")
    private List<String> authorityChain = null;
    @JsonProperty(value="attestation_statement")
    private KeyAttestationResponseAttestationStatement attestationStatement = null;

    public KeyAttestationResponse authorityChain(List<String> authorityChain) {
        this.authorityChain = authorityChain;
        return this;
    }

    public KeyAttestationResponse addAuthorityChainItem(String authorityChainItem) {
        if (this.authorityChain == null) {
            this.authorityChain = new ArrayList<String>();
        }
        this.authorityChain.add(authorityChainItem);
        return this;
    }

    @ApiModelProperty(value="DER-encoded certificate chain for the authority issuing the key attestation statement.")
    @JsonProperty(value="authority_chain")
    public List<String> getAuthorityChain() {
        return this.authorityChain;
    }

    @JsonProperty(value="authority_chain")
    public void setAuthorityChain(List<String> authorityChain) {
        this.authorityChain = authorityChain;
    }

    public KeyAttestationResponse attestationStatement(KeyAttestationResponseAttestationStatement attestationStatement) {
        this.attestationStatement = attestationStatement;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="attestation_statement")
    public KeyAttestationResponseAttestationStatement getAttestationStatement() {
        return this.attestationStatement;
    }

    @JsonProperty(value="attestation_statement")
    public void setAttestationStatement(KeyAttestationResponseAttestationStatement attestationStatement) {
        this.attestationStatement = attestationStatement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyAttestationResponse keyAttestationResponse = (KeyAttestationResponse)o;
        return Objects.equals(this.authorityChain, keyAttestationResponse.authorityChain) && Objects.equals(this.attestationStatement, keyAttestationResponse.attestationStatement);
    }

    public int hashCode() {
        return Objects.hash(this.authorityChain, this.attestationStatement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyAttestationResponse {\n");
        sb.append("    authorityChain: ").append(this.toIndentedString(this.authorityChain)).append("\n");
        sb.append("    attestationStatement: ").append(this.toIndentedString(this.attestationStatement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

