/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KeyFormat {
    private String value;
    public static final KeyFormat DEFAULT = new KeyFormat("Default");
    public static final KeyFormat PKCS8 = new KeyFormat("Pkcs8");
    private static final Map<String, KeyFormat> valueMap = new HashMap<String, KeyFormat>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private KeyFormat(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyFormat[] values() {
        valueMapLock.lock();
        try {
            KeyFormat[] keyFormatArray = valueMap.values().toArray(new KeyFormat[valueMap.values().size()]);
            return keyFormatArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static KeyFormat fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                KeyFormat keyFormat = valueMap.get(val);
                return keyFormat;
            }
            KeyFormat newValue = new KeyFormat(val);
            valueMap.put(val, newValue);
            KeyFormat keyFormat = newValue;
            return keyFormat;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("Default", DEFAULT);
        valueMap.put("Pkcs8", PKCS8);
    }
}

