/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KeyOperations {
    private String value;
    public static final KeyOperations SIGN = new KeyOperations("SIGN");
    public static final KeyOperations VERIFY = new KeyOperations("VERIFY");
    public static final KeyOperations ENCRYPT = new KeyOperations("ENCRYPT");
    public static final KeyOperations DECRYPT = new KeyOperations("DECRYPT");
    public static final KeyOperations WRAPKEY = new KeyOperations("WRAPKEY");
    public static final KeyOperations UNWRAPKEY = new KeyOperations("UNWRAPKEY");
    public static final KeyOperations DERIVEKEY = new KeyOperations("DERIVEKEY");
    public static final KeyOperations AGREEKEY = new KeyOperations("AGREEKEY");
    public static final KeyOperations MACGENERATE = new KeyOperations("MACGENERATE");
    public static final KeyOperations MACVERIFY = new KeyOperations("MACVERIFY");
    public static final KeyOperations EXPORT = new KeyOperations("EXPORT");
    public static final KeyOperations APPMANAGEABLE = new KeyOperations("APPMANAGEABLE");
    private static final Map<String, KeyOperations> valueMap = new HashMap<String, KeyOperations>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private KeyOperations(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyOperations[] values() {
        valueMapLock.lock();
        try {
            KeyOperations[] keyOperationsArray = valueMap.values().toArray(new KeyOperations[valueMap.values().size()]);
            return keyOperationsArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static KeyOperations fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                KeyOperations keyOperations = valueMap.get(val);
                return keyOperations;
            }
            KeyOperations newValue = new KeyOperations(val);
            valueMap.put(val, newValue);
            KeyOperations keyOperations = newValue;
            return keyOperations;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("SIGN", SIGN);
        valueMap.put("VERIFY", VERIFY);
        valueMap.put("ENCRYPT", ENCRYPT);
        valueMap.put("DECRYPT", DECRYPT);
        valueMap.put("WRAPKEY", WRAPKEY);
        valueMap.put("UNWRAPKEY", UNWRAPKEY);
        valueMap.put("DERIVEKEY", DERIVEKEY);
        valueMap.put("AGREEKEY", AGREEKEY);
        valueMap.put("MACGENERATE", MACGENERATE);
        valueMap.put("MACVERIFY", MACVERIFY);
        valueMap.put("EXPORT", EXPORT);
        valueMap.put("APPMANAGEABLE", APPMANAGEABLE);
    }
}

