/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.PluginSource;
import com.fortanix.sdkms.v1.model.PluginType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PluginRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="add_groups")
    private List<String> addGroups = new ArrayList<String>();
    @JsonProperty(value="del_groups")
    private List<String> delGroups = null;
    @JsonProperty(value="default_group")
    private String defaultGroup = null;
    @JsonProperty(value="source")
    private PluginSource source = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="plugin_type")
    private PluginType pluginType = null;

    public PluginRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the plugin. Plugin names must be unique within an account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public PluginRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of this plugin.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public PluginRequest addGroups(List<String> addGroups) {
        this.addGroups = addGroups;
        return this;
    }

    public PluginRequest addAddGroupsItem(String addGroupsItem) {
        this.addGroups.add(addGroupsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of Security Group IDs to add to this plugin.")
    @JsonProperty(value="add_groups")
    public List<String> getAddGroups() {
        return this.addGroups;
    }

    @JsonProperty(value="add_groups")
    public void setAddGroups(List<String> addGroups) {
        this.addGroups = addGroups;
    }

    public PluginRequest delGroups(List<String> delGroups) {
        this.delGroups = delGroups;
        return this;
    }

    public PluginRequest addDelGroupsItem(String delGroupsItem) {
        if (this.delGroups == null) {
            this.delGroups = new ArrayList<String>();
        }
        this.delGroups.add(delGroupsItem);
        return this;
    }

    @ApiModelProperty(value="An array of security group IDs to remove from this plugin.")
    @JsonProperty(value="del_groups")
    public List<String> getDelGroups() {
        return this.delGroups;
    }

    @JsonProperty(value="del_groups")
    public void setDelGroups(List<String> delGroups) {
        this.delGroups = delGroups;
    }

    public PluginRequest defaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
        return this;
    }

    @ApiModelProperty(required=true, value="The default group of this plugin. This is the group where security objects will be created by default by this plugin.")
    @JsonProperty(value="default_group")
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    @JsonProperty(value="default_group")
    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public PluginRequest source(PluginSource source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="source")
    public PluginSource getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(PluginSource source) {
        this.source = source;
    }

    public PluginRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Whether this plugin is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PluginRequest pluginType(PluginType pluginType) {
        this.pluginType = pluginType;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="plugin_type")
    public PluginType getPluginType() {
        return this.pluginType;
    }

    @JsonProperty(value="plugin_type")
    public void setPluginType(PluginType pluginType) {
        this.pluginType = pluginType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginRequest pluginRequest = (PluginRequest)o;
        return Objects.equals(this.name, pluginRequest.name) && Objects.equals(this.description, pluginRequest.description) && Objects.equals(this.addGroups, pluginRequest.addGroups) && Objects.equals(this.delGroups, pluginRequest.delGroups) && Objects.equals(this.defaultGroup, pluginRequest.defaultGroup) && Objects.equals(this.source, pluginRequest.source) && Objects.equals(this.enabled, pluginRequest.enabled) && Objects.equals(this.pluginType, pluginRequest.pluginType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.addGroups, this.delGroups, this.defaultGroup, this.source, this.enabled, this.pluginType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PluginRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    addGroups: ").append(this.toIndentedString(this.addGroups)).append("\n");
        sb.append("    delGroups: ").append(this.toIndentedString(this.delGroups)).append("\n");
        sb.append("    defaultGroup: ").append(this.toIndentedString(this.defaultGroup)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    pluginType: ").append(this.toIndentedString(this.pluginType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

