/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RevocationReasonCode {
    private String value;
    public static final RevocationReasonCode UNSPECIFIED = new RevocationReasonCode("Unspecified");
    public static final RevocationReasonCode KEYCOMPROMISE = new RevocationReasonCode("KeyCompromise");
    public static final RevocationReasonCode CACOMPROMISE = new RevocationReasonCode("CACompromise");
    public static final RevocationReasonCode AFFILIATIONCHANGED = new RevocationReasonCode("AffiliationChanged");
    public static final RevocationReasonCode SUPERSEDED = new RevocationReasonCode("Superseded");
    public static final RevocationReasonCode CESSATIONOFOPERATION = new RevocationReasonCode("CessationOfOperation");
    public static final RevocationReasonCode PRIVILEGEWITHDRAWN = new RevocationReasonCode("PrivilegeWithdrawn");
    private static final Map<String, RevocationReasonCode> valueMap = new HashMap<String, RevocationReasonCode>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private RevocationReasonCode(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RevocationReasonCode[] values() {
        valueMapLock.lock();
        try {
            RevocationReasonCode[] revocationReasonCodeArray = valueMap.values().toArray(new RevocationReasonCode[valueMap.values().size()]);
            return revocationReasonCodeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static RevocationReasonCode fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                RevocationReasonCode revocationReasonCode = valueMap.get(val);
                return revocationReasonCode;
            }
            RevocationReasonCode newValue = new RevocationReasonCode(val);
            valueMap.put(val, newValue);
            RevocationReasonCode revocationReasonCode = newValue;
            return revocationReasonCode;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("Unspecified", UNSPECIFIED);
        valueMap.put("KeyCompromise", KEYCOMPROMISE);
        valueMap.put("CACompromise", CACOMPROMISE);
        valueMap.put("AffiliationChanged", AFFILIATIONCHANGED);
        valueMap.put("Superseded", SUPERSEDED);
        valueMap.put("CessationOfOperation", CESSATIONOFOPERATION);
        valueMap.put("PrivilegeWithdrawn", PRIVILEGEWITHDRAWN);
    }
}

