/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.RsaEncryptionPolicy;
import com.fortanix.sdkms.v1.model.RsaSignaturePolicy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="RSA-specific options.")
@JsonIgnoreProperties(ignoreUnknown=true)
public class RsaOptions {
    @JsonProperty(value="key_size")
    private Integer keySize = null;
    @JsonProperty(value="public_exponent")
    private Integer publicExponent = null;
    @JsonProperty(value="encryption_policy")
    private List<RsaEncryptionPolicy> encryptionPolicy = null;
    @JsonProperty(value="signature_policy")
    private List<RsaSignaturePolicy> signaturePolicy = null;

    public RsaOptions keySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    @ApiModelProperty(value="Specify on Create only. Returned on Get. Size in bits (not bytes) of the RSA key.")
    @JsonProperty(value="key_size")
    public Integer getKeySize() {
        return this.keySize;
    }

    @JsonProperty(value="key_size")
    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    public RsaOptions publicExponent(Integer publicExponent) {
        this.publicExponent = publicExponent;
        return this;
    }

    @ApiModelProperty(value="Specify on Create only. Public exponent to use for generating the RSA key.")
    @JsonProperty(value="public_exponent")
    public Integer getPublicExponent() {
        return this.publicExponent;
    }

    @JsonProperty(value="public_exponent")
    public void setPublicExponent(Integer publicExponent) {
        this.publicExponent = publicExponent;
    }

    public RsaOptions encryptionPolicy(List<RsaEncryptionPolicy> encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
        return this;
    }

    public RsaOptions addEncryptionPolicyItem(RsaEncryptionPolicy encryptionPolicyItem) {
        if (this.encryptionPolicy == null) {
            this.encryptionPolicy = new ArrayList<RsaEncryptionPolicy>();
        }
        this.encryptionPolicy.add(encryptionPolicyItem);
        return this;
    }

    @ApiModelProperty(value="Encryption policy for this RSA key. When doing an encryption or key wrapping operation, the policies are evaluated against the specified parameters one by one. If one matches, the operation is allowed. If none match, including if the policy list is empty, the operation is disallowed. Missing optional parameters will have their defaults specified according to the matched policy. The default for new keys is `[{\"padding\":{\"OAEP\":{}}]`. If (part of) a constraint is not specified, anything is allowed for that constraint. To impose no constraints, specify `[{}]`. ")
    @JsonProperty(value="encryption_policy")
    public List<RsaEncryptionPolicy> getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    @JsonProperty(value="encryption_policy")
    public void setEncryptionPolicy(List<RsaEncryptionPolicy> encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    public RsaOptions signaturePolicy(List<RsaSignaturePolicy> signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
        return this;
    }

    public RsaOptions addSignaturePolicyItem(RsaSignaturePolicy signaturePolicyItem) {
        if (this.signaturePolicy == null) {
            this.signaturePolicy = new ArrayList<RsaSignaturePolicy>();
        }
        this.signaturePolicy.add(signaturePolicyItem);
        return this;
    }

    @ApiModelProperty(value="Signature policy for this RSA key. When doing a signature operation, the policies are evaluated against the specified parameters one by one. If one matches, the operation is allowed. If none match, including if the policy list is empty, the operation is disallowed. Missing optional parameters will have their defaults specified according to the matched policy. The default for new keys is `[{}]` (no constraints). If (part of) a constraint is not specified, anything is allowed for that constraint. ")
    @JsonProperty(value="signature_policy")
    public List<RsaSignaturePolicy> getSignaturePolicy() {
        return this.signaturePolicy;
    }

    @JsonProperty(value="signature_policy")
    public void setSignaturePolicy(List<RsaSignaturePolicy> signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RsaOptions rsaOptions = (RsaOptions)o;
        return Objects.equals(this.keySize, rsaOptions.keySize) && Objects.equals(this.publicExponent, rsaOptions.publicExponent) && Objects.equals(this.encryptionPolicy, rsaOptions.encryptionPolicy) && Objects.equals(this.signaturePolicy, rsaOptions.signaturePolicy);
    }

    public int hashCode() {
        return Objects.hash(this.keySize, this.publicExponent, this.encryptionPolicy, this.signaturePolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RsaOptions {\n");
        sb.append("    keySize: ").append(this.toIndentedString(this.keySize)).append("\n");
        sb.append("    publicExponent: ").append(this.toIndentedString(this.publicExponent)).append("\n");
        sb.append("    encryptionPolicy: ").append(this.toIndentedString(this.encryptionPolicy)).append("\n");
        sb.append("    signaturePolicy: ").append(this.toIndentedString(this.signaturePolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

