/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.SignatureMode;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VerifyRequestEx {
    @JsonProperty(value="key")
    private SobjectDescriptor key = null;
    @JsonProperty(value="hash_alg")
    private DigestAlgorithm hashAlg = null;
    @JsonProperty(value="hash")
    private byte[] hash = null;
    @JsonProperty(value="data")
    private byte[] data = null;
    @JsonProperty(value="signature")
    private byte[] signature = null;
    @JsonProperty(value="mode")
    private SignatureMode mode = null;

    public VerifyRequestEx key(SobjectDescriptor key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="key")
    public SobjectDescriptor getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(SobjectDescriptor key) {
        this.key = key;
    }

    public VerifyRequestEx hashAlg(DigestAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="hash_alg")
    public DigestAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    @JsonProperty(value="hash_alg")
    public void setHashAlg(DigestAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public VerifyRequestEx hash(byte[] hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(value="The hash (not supported in FIPS mode) of the data on which the signature is being verified. Exactly one of `hash` and `data` is required. ")
    @JsonProperty(value="hash")
    public byte[] getHash() {
        return this.hash;
    }

    @JsonProperty(value="hash")
    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public VerifyRequestEx data(byte[] data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="The data on which the signature is being verified. Exactly one of `hash` and `data` is required. To reduce request size and avoid reaching the request size limit, prefer `hash`. ")
    @JsonProperty(value="data")
    public byte[] getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(byte[] data) {
        this.data = data;
    }

    public VerifyRequestEx signature(byte[] signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(required=true, value="A signature created with the private key corresponding to this public key.")
    @JsonProperty(value="signature")
    public byte[] getSignature() {
        return this.signature;
    }

    @JsonProperty(value="signature")
    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public VerifyRequestEx mode(SignatureMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mode")
    public SignatureMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(SignatureMode mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyRequestEx verifyRequestEx = (VerifyRequestEx)o;
        return Objects.equals(this.key, verifyRequestEx.key) && Objects.equals(this.hashAlg, verifyRequestEx.hashAlg) && Objects.equals(this.hash, verifyRequestEx.hash) && Objects.equals(this.data, verifyRequestEx.data) && Objects.equals(this.signature, verifyRequestEx.signature) && Objects.equals(this.mode, verifyRequestEx.mode);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.hashAlg, this.hash, this.data, this.signature, this.mode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerifyRequestEx {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    hashAlg: ").append(this.toIndentedString(this.hashAlg)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

