/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.api;

import com.fortanix.sdkms.v1.ApiClient;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.Configuration;
import com.fortanix.sdkms.v1.Pair;
import com.fortanix.sdkms.v1.model.ChildAccountUser;
import com.fortanix.sdkms.v1.model.ChildAccountUserRequest;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ChildAccountUsersApi {
    private ApiClient apiClient;

    public ChildAccountUsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ChildAccountUsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ChildAccountUser createChildAccountUser(ChildAccountUserRequest body) throws ApiException {
        ChildAccountUserRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createChildAccountUser");
        }
        String localVarPath = "/sys/v1/users/child_account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<ChildAccountUser> localVarReturnType = new GenericType<ChildAccountUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteChildAccountUser(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteChildAccountUser");
        }
        String localVarPath = "/sys/v1/users/child_account/{user-id}".replaceAll("\\{user-id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<ChildAccountUser> getAllChildAccountUsers(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAllChildAccountUsers");
        }
        String localVarPath = "/sys/v1/users/child_account/{account-id}/all".replaceAll("\\{account-id\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<List<ChildAccountUser>> localVarReturnType = new GenericType<List<ChildAccountUser>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChildAccountUser getChildAccountUser(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getChildAccountUser");
        }
        String localVarPath = "/sys/v1/users/child_account/{user-id}".replaceAll("\\{user-id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<ChildAccountUser> localVarReturnType = new GenericType<ChildAccountUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChildAccountUser updateChildAccountUser(String userId, ChildAccountUserRequest body) throws ApiException {
        ChildAccountUserRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateChildAccountUser");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateChildAccountUser");
        }
        String localVarPath = "/sys/v1/users/child_account/{user-id}".replaceAll("\\{user-id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<ChildAccountUser> localVarReturnType = new GenericType<ChildAccountUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

