/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.api;

import com.fortanix.sdkms.v1.ApiClient;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.Configuration;
import com.fortanix.sdkms.v1.Pair;
import com.fortanix.sdkms.v1.model.BatchSignRequest;
import com.fortanix.sdkms.v1.model.BatchSignResponse;
import com.fortanix.sdkms.v1.model.BatchVerifyRequest;
import com.fortanix.sdkms.v1.model.BatchVerifyResponse;
import com.fortanix.sdkms.v1.model.SignRequest;
import com.fortanix.sdkms.v1.model.SignRequestEx;
import com.fortanix.sdkms.v1.model.SignResponse;
import com.fortanix.sdkms.v1.model.VerifyRequest;
import com.fortanix.sdkms.v1.model.VerifyRequestEx;
import com.fortanix.sdkms.v1.model.VerifyResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class SignAndVerifyApi {
    private ApiClient apiClient;

    public SignAndVerifyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SignAndVerifyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BatchSignResponse batchSign(BatchSignRequest body) throws ApiException {
        BatchSignRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchSign");
        }
        String localVarPath = "/crypto/v1/keys/batch/sign";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<BatchSignResponse> localVarReturnType = new GenericType<BatchSignResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BatchVerifyResponse batchVerify(BatchVerifyRequest body) throws ApiException {
        BatchVerifyRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchVerify");
        }
        String localVarPath = "/crypto/v1/keys/batch/verify";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<BatchVerifyResponse> localVarReturnType = new GenericType<BatchVerifyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SignResponse sign(String keyId, SignRequest body) throws ApiException {
        SignRequest localVarPostBody = body;
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling sign");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling sign");
        }
        String localVarPath = "/crypto/v1/keys/{key-id}/sign".replaceAll("\\{key-id\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<SignResponse> localVarReturnType = new GenericType<SignResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SignResponse signEx(SignRequestEx body) throws ApiException {
        SignRequestEx localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling signEx");
        }
        String localVarPath = "/crypto/v1/sign";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<SignResponse> localVarReturnType = new GenericType<SignResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public VerifyResponse verify(String keyId, VerifyRequest body) throws ApiException {
        VerifyRequest localVarPostBody = body;
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling verify");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling verify");
        }
        String localVarPath = "/crypto/v1/keys/{key-id}/verify".replaceAll("\\{key-id\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<VerifyResponse> localVarReturnType = new GenericType<VerifyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public VerifyResponse verifyEx(VerifyRequestEx body) throws ApiException {
        VerifyRequestEx localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling verifyEx");
        }
        String localVarPath = "/crypto/v1/verify";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerToken"};
        GenericType<VerifyResponse> localVarReturnType = new GenericType<VerifyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

