/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.AccountState;
import com.fortanix.sdkms.v1.model.AuthConfig;
import com.fortanix.sdkms.v1.model.AuthType;
import com.fortanix.sdkms.v1.model.KeyUndoPolicy;
import com.fortanix.sdkms.v1.model.LoggingConfig;
import com.fortanix.sdkms.v1.model.NotificationPref;
import com.fortanix.sdkms.v1.model.SubscriptionChangeRequest;
import com.fortanix.sdkms.v1.model.SubscriptionType;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Account {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="acct_id")
    private String acctId = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="organization")
    private String organization = null;
    @JsonProperty(value="country")
    private String country = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="notification_pref")
    private NotificationPref notificationPref = null;
    @JsonProperty(value="auth_config")
    private AuthConfig authConfig = null;
    @JsonProperty(value="subscription")
    private SubscriptionType subscription = null;
    @JsonProperty(value="state")
    private AccountState state = null;
    @JsonProperty(value="auth_type")
    private AuthType authType = null;
    @JsonProperty(value="logging_configs")
    private Map<String, LoggingConfig> loggingConfigs = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="initial_purchase_at")
    private String initialPurchaseAt = null;
    @JsonProperty(value="pending_subscription_change_request")
    private SubscriptionChangeRequest pendingSubscriptionChangeRequest = null;
    @JsonProperty(value="custom_metadata")
    private Map<String, String> customMetadata = null;
    @JsonProperty(value="key_undo_policy")
    private KeyUndoPolicy keyUndoPolicy = null;

    public Account name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the account. Account names must be unique within an DSM instance.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Account acctId(String acctId) {
        this.acctId = acctId;
        return this;
    }

    @ApiModelProperty(required=true, value="Account ID uniquely identifying this account.")
    @JsonProperty(value="acct_id")
    public String getAcctId() {
        return this.acctId;
    }

    @JsonProperty(value="acct_id")
    public void setAcctId(String acctId) {
        this.acctId = acctId;
    }

    public Account description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of this account.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Account organization(String organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(value="Organization (e.g. company name) that owns this account")
    @JsonProperty(value="organization")
    public String getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public Account country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="Main country associated with this account")
    @JsonProperty(value="country")
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    public void setCountry(String country) {
        this.country = country;
    }

    public Account phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="Contact phone number associated with this account")
    @JsonProperty(value="phone")
    public String getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Account notificationPref(NotificationPref notificationPref) {
        this.notificationPref = notificationPref;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="notification_pref")
    public NotificationPref getNotificationPref() {
        return this.notificationPref;
    }

    @JsonProperty(value="notification_pref")
    public void setNotificationPref(NotificationPref notificationPref) {
        this.notificationPref = notificationPref;
    }

    public Account authConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="auth_config")
    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    @JsonProperty(value="auth_config")
    public void setAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    public Account subscription(SubscriptionType subscription) {
        this.subscription = subscription;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="subscription")
    public SubscriptionType getSubscription() {
        return this.subscription;
    }

    @JsonProperty(value="subscription")
    public void setSubscription(SubscriptionType subscription) {
        this.subscription = subscription;
    }

    public Account state(AccountState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="state")
    public AccountState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(AccountState state) {
        this.state = state;
    }

    public Account authType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="auth_type")
    public AuthType getAuthType() {
        return this.authType;
    }

    @JsonProperty(value="auth_type")
    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public Account loggingConfigs(Map<String, LoggingConfig> loggingConfigs) {
        this.loggingConfigs = loggingConfigs;
        return this;
    }

    public Account putLoggingConfigsItem(String key, LoggingConfig loggingConfigsItem) {
        if (this.loggingConfigs == null) {
            this.loggingConfigs = new HashMap<String, LoggingConfig>();
        }
        this.loggingConfigs.put(key, loggingConfigsItem);
        return this;
    }

    @ApiModelProperty(value="Map from UUIDs to LoggingConfig objects")
    @JsonProperty(value="logging_configs")
    public Map<String, LoggingConfig> getLoggingConfigs() {
        return this.loggingConfigs;
    }

    @JsonProperty(value="logging_configs")
    public void setLoggingConfigs(Map<String, LoggingConfig> loggingConfigs) {
        this.loggingConfigs = loggingConfigs;
    }

    public Account enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether this account is enabled. This may only be changed by sysadmins.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Account createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="When this account was created.")
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Account initialPurchaseAt(String initialPurchaseAt) {
        this.initialPurchaseAt = initialPurchaseAt;
        return this;
    }

    @ApiModelProperty(value="When this accout was upgraded a paid subscription.")
    @JsonProperty(value="initial_purchase_at")
    public String getInitialPurchaseAt() {
        return this.initialPurchaseAt;
    }

    @JsonProperty(value="initial_purchase_at")
    public void setInitialPurchaseAt(String initialPurchaseAt) {
        this.initialPurchaseAt = initialPurchaseAt;
    }

    public Account pendingSubscriptionChangeRequest(SubscriptionChangeRequest pendingSubscriptionChangeRequest) {
        this.pendingSubscriptionChangeRequest = pendingSubscriptionChangeRequest;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="pending_subscription_change_request")
    public SubscriptionChangeRequest getPendingSubscriptionChangeRequest() {
        return this.pendingSubscriptionChangeRequest;
    }

    @JsonProperty(value="pending_subscription_change_request")
    public void setPendingSubscriptionChangeRequest(SubscriptionChangeRequest pendingSubscriptionChangeRequest) {
        this.pendingSubscriptionChangeRequest = pendingSubscriptionChangeRequest;
    }

    public Account customMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
        return this;
    }

    public Account putCustomMetadataItem(String key, String customMetadataItem) {
        if (this.customMetadata == null) {
            this.customMetadata = new HashMap<String, String>();
        }
        this.customMetadata.put(key, customMetadataItem);
        return this;
    }

    @ApiModelProperty(value="Sysadmin-defined metadata for this account. Stored as key-value pairs. This field is only visible to sysadmin users. ")
    @JsonProperty(value="custom_metadata")
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="custom_metadata")
    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public Account keyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="key_undo_policy")
    public KeyUndoPolicy getKeyUndoPolicy() {
        return this.keyUndoPolicy;
    }

    @JsonProperty(value="key_undo_policy")
    public void setKeyUndoPolicy(KeyUndoPolicy keyUndoPolicy) {
        this.keyUndoPolicy = keyUndoPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.name, account.name) && Objects.equals(this.acctId, account.acctId) && Objects.equals(this.description, account.description) && Objects.equals(this.organization, account.organization) && Objects.equals(this.country, account.country) && Objects.equals(this.phone, account.phone) && Objects.equals(this.notificationPref, account.notificationPref) && Objects.equals(this.authConfig, account.authConfig) && Objects.equals(this.subscription, account.subscription) && Objects.equals(this.state, account.state) && Objects.equals(this.authType, account.authType) && Objects.equals(this.loggingConfigs, account.loggingConfigs) && Objects.equals(this.enabled, account.enabled) && Objects.equals(this.createdAt, account.createdAt) && Objects.equals(this.initialPurchaseAt, account.initialPurchaseAt) && Objects.equals(this.pendingSubscriptionChangeRequest, account.pendingSubscriptionChangeRequest) && Objects.equals(this.customMetadata, account.customMetadata) && Objects.equals(this.keyUndoPolicy, account.keyUndoPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.acctId, this.description, this.organization, this.country, this.phone, this.notificationPref, this.authConfig, this.subscription, this.state, this.authType, this.loggingConfigs, this.enabled, this.createdAt, this.initialPurchaseAt, this.pendingSubscriptionChangeRequest, this.customMetadata, this.keyUndoPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    acctId: ").append(this.toIndentedString(this.acctId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    notificationPref: ").append(this.toIndentedString(this.notificationPref)).append("\n");
        sb.append("    authConfig: ").append(this.toIndentedString(this.authConfig)).append("\n");
        sb.append("    subscription: ").append(this.toIndentedString(this.subscription)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    authType: ").append(this.toIndentedString(this.authType)).append("\n");
        sb.append("    loggingConfigs: ").append(this.toIndentedString(this.loggingConfigs)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    initialPurchaseAt: ").append(this.toIndentedString(this.initialPurchaseAt)).append("\n");
        sb.append("    pendingSubscriptionChangeRequest: ").append(this.toIndentedString(this.pendingSubscriptionChangeRequest)).append("\n");
        sb.append("    customMetadata: ").append(this.toIndentedString(this.customMetadata)).append("\n");
        sb.append("    keyUndoPolicy: ").append(this.toIndentedString(this.keyUndoPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

