/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppPermissions {
    private String value;
    public static final AppPermissions ENCRYPT = new AppPermissions("ENCRYPT");
    public static final AppPermissions DECRYPT = new AppPermissions("DECRYPT");
    public static final AppPermissions MASKDECRYPT = new AppPermissions("MASKDECRYPT");
    public static final AppPermissions WRAPKEY = new AppPermissions("WRAPKEY");
    public static final AppPermissions UNWRAPKEY = new AppPermissions("UNWRAPKEY");
    public static final AppPermissions DERIVEKEY = new AppPermissions("DERIVEKEY");
    public static final AppPermissions MACGENERATE = new AppPermissions("MACGENERATE");
    public static final AppPermissions MACVERIFY = new AppPermissions("MACVERIFY");
    public static final AppPermissions MANAGE = new AppPermissions("MANAGE");
    public static final AppPermissions SIGN = new AppPermissions("SIGN");
    public static final AppPermissions VERIFY = new AppPermissions("VERIFY");
    public static final AppPermissions AGREEKEY = new AppPermissions("AGREEKEY");
    public static final AppPermissions EXPORT = new AppPermissions("EXPORT");
    private static final Map<String, AppPermissions> valueMap = new HashMap<String, AppPermissions>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private AppPermissions(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppPermissions[] values() {
        valueMapLock.lock();
        try {
            AppPermissions[] appPermissionsArray = valueMap.values().toArray(new AppPermissions[valueMap.values().size()]);
            return appPermissionsArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static AppPermissions fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                AppPermissions appPermissions = valueMap.get(val);
                return appPermissions;
            }
            AppPermissions newValue = new AppPermissions(val);
            valueMap.put(val, newValue);
            AppPermissions appPermissions = newValue;
            return appPermissions;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("ENCRYPT", ENCRYPT);
        valueMap.put("DECRYPT", DECRYPT);
        valueMap.put("MASKDECRYPT", MASKDECRYPT);
        valueMap.put("WRAPKEY", WRAPKEY);
        valueMap.put("UNWRAPKEY", UNWRAPKEY);
        valueMap.put("DERIVEKEY", DERIVEKEY);
        valueMap.put("MACGENERATE", MACGENERATE);
        valueMap.put("MACVERIFY", MACVERIFY);
        valueMap.put("MANAGE", MANAGE);
        valueMap.put("SIGN", SIGN);
        valueMap.put("VERIFY", VERIFY);
        valueMap.put("AGREEKEY", AGREEKEY);
        valueMap.put("EXPORT", EXPORT);
    }
}

