/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApprovalStatus {
    private String value;
    public static final ApprovalStatus PENDING = new ApprovalStatus("PENDING");
    public static final ApprovalStatus APPROVED = new ApprovalStatus("APPROVED");
    public static final ApprovalStatus DENIED = new ApprovalStatus("DENIED");
    public static final ApprovalStatus FAILED = new ApprovalStatus("FAILED");
    private static final Map<String, ApprovalStatus> valueMap = new HashMap<String, ApprovalStatus>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private ApprovalStatus(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApprovalStatus[] values() {
        valueMapLock.lock();
        try {
            ApprovalStatus[] approvalStatusArray = valueMap.values().toArray(new ApprovalStatus[valueMap.values().size()]);
            return approvalStatusArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static ApprovalStatus fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                ApprovalStatus approvalStatus = valueMap.get(val);
                return approvalStatus;
            }
            ApprovalStatus newValue = new ApprovalStatus(val);
            valueMap.put(val, newValue);
            ApprovalStatus approvalStatus = newValue;
            return approvalStatus;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("PENDING", PENDING);
        valueMap.put("APPROVED", APPROVED);
        valueMap.put("DENIED", DENIED);
        valueMap.put("FAILED", FAILED);
    }
}

