/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.U2fMfaChallengeResponse;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthResponse {
    @JsonProperty(value="token_type")
    private String tokenType = null;
    @JsonProperty(value="expires_in")
    private Integer expiresIn = null;
    @JsonProperty(value="access_token")
    private String accessToken = null;
    @JsonProperty(value="entity_id")
    private String entityId = null;
    @JsonProperty(value="challenge")
    private U2fMfaChallengeResponse challenge = null;

    public AuthResponse tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="token_type")
    public String getTokenType() {
        return this.tokenType;
    }

    @JsonProperty(value="token_type")
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public AuthResponse expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of seconds from token issuance that the token will expire.")
    @JsonProperty(value="expires_in")
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    @JsonProperty(value="expires_in")
    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public AuthResponse accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="Bearer token to be used to authenticate to other APIs.")
    @JsonProperty(value="access_token")
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="access_token")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public AuthResponse entityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @ApiModelProperty(required=true, value="The UUID of the entity that was authorized. For users, this will be the user's UUID. For applications, this will be the application's UUID. ")
    @JsonProperty(value="entity_id")
    public String getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entity_id")
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public AuthResponse challenge(U2fMfaChallengeResponse challenge) {
        this.challenge = challenge;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="challenge")
    public U2fMfaChallengeResponse getChallenge() {
        return this.challenge;
    }

    @JsonProperty(value="challenge")
    public void setChallenge(U2fMfaChallengeResponse challenge) {
        this.challenge = challenge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthResponse authResponse = (AuthResponse)o;
        return Objects.equals(this.tokenType, authResponse.tokenType) && Objects.equals(this.expiresIn, authResponse.expiresIn) && Objects.equals(this.accessToken, authResponse.accessToken) && Objects.equals(this.entityId, authResponse.entityId) && Objects.equals(this.challenge, authResponse.challenge);
    }

    public int hashCode() {
        return Objects.hash(this.tokenType, this.expiresIn, this.accessToken, this.entityId, this.challenge);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthResponse {\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    challenge: ").append(this.toIndentedString(this.challenge)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

