/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CipherMode;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DecryptInitRequestEx {
    @JsonProperty(value="key")
    private SobjectDescriptor key = null;
    @JsonProperty(value="alg")
    private ObjectType alg = null;
    @JsonProperty(value="mode")
    private CipherMode mode = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;
    @JsonProperty(value="ad")
    private byte[] ad = null;

    public DecryptInitRequestEx key(SobjectDescriptor key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="key")
    public SobjectDescriptor getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(SobjectDescriptor key) {
        this.key = key;
    }

    public DecryptInitRequestEx alg(ObjectType alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="alg")
    public ObjectType getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    public void setAlg(ObjectType alg) {
        this.alg = alg;
    }

    public DecryptInitRequestEx mode(CipherMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mode")
    public CipherMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(CipherMode mode) {
        this.mode = mode;
    }

    public DecryptInitRequestEx iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="The initialization value used to encrypt this ciphertext. This field is required for symmetric ciphers, and ignored for asymmetric ciphers. ")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public DecryptInitRequestEx ad(byte[] ad) {
        this.ad = ad;
        return this;
    }

    @ApiModelProperty(value="The authenticated data used with this ciphertext and authentication tag. This field is required for symmetric ciphers using cipher mode GCM or CCM, and must not be specified for all other ciphers. ")
    @JsonProperty(value="ad")
    public byte[] getAd() {
        return this.ad;
    }

    @JsonProperty(value="ad")
    public void setAd(byte[] ad) {
        this.ad = ad;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecryptInitRequestEx decryptInitRequestEx = (DecryptInitRequestEx)o;
        return Objects.equals(this.key, decryptInitRequestEx.key) && Objects.equals(this.alg, decryptInitRequestEx.alg) && Objects.equals(this.mode, decryptInitRequestEx.mode) && Objects.equals(this.iv, decryptInitRequestEx.iv) && Objects.equals(this.ad, decryptInitRequestEx.ad);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.alg, this.mode, this.iv, this.ad);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecryptInitRequestEx {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("    ad: ").append(this.toIndentedString(this.ad)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

