/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CreatorType;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import com.fortanix.sdkms.v1.model.SplittingMethod;
import com.fortanix.sdkms.v1.model.WrapKeyParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Request to export security object as components")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExportSobjectComponentsRequest {
    @JsonProperty(value="key")
    private SobjectDescriptor key = null;
    @JsonProperty(value="wrap_key_params")
    private WrapKeyParams wrapKeyParams = null;
    @JsonProperty(value="custodians")
    private List<CreatorType> custodians = new ArrayList<CreatorType>();
    @JsonProperty(value="method")
    private SplittingMethod method = null;
    @JsonProperty(value="description")
    private String description = null;

    public ExportSobjectComponentsRequest key(SobjectDescriptor key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="key")
    public SobjectDescriptor getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(SobjectDescriptor key) {
        this.key = key;
    }

    public ExportSobjectComponentsRequest wrapKeyParams(WrapKeyParams wrapKeyParams) {
        this.wrapKeyParams = wrapKeyParams;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="wrap_key_params")
    public WrapKeyParams getWrapKeyParams() {
        return this.wrapKeyParams;
    }

    @JsonProperty(value="wrap_key_params")
    public void setWrapKeyParams(WrapKeyParams wrapKeyParams) {
        this.wrapKeyParams = wrapKeyParams;
    }

    public ExportSobjectComponentsRequest custodians(List<CreatorType> custodians) {
        this.custodians = custodians;
        return this;
    }

    public ExportSobjectComponentsRequest addCustodiansItem(CreatorType custodiansItem) {
        this.custodians.add(custodiansItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Map from USER or App to its UUIDs")
    @JsonProperty(value="custodians")
    public List<CreatorType> getCustodians() {
        return this.custodians;
    }

    @JsonProperty(value="custodians")
    public void setCustodians(List<CreatorType> custodians) {
        this.custodians = custodians;
    }

    public ExportSobjectComponentsRequest method(SplittingMethod method) {
        this.method = method;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="method")
    public SplittingMethod getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    public void setMethod(SplittingMethod method) {
        this.method = method;
    }

    public ExportSobjectComponentsRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="description to the export request")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportSobjectComponentsRequest exportSobjectComponentsRequest = (ExportSobjectComponentsRequest)o;
        return Objects.equals(this.key, exportSobjectComponentsRequest.key) && Objects.equals(this.wrapKeyParams, exportSobjectComponentsRequest.wrapKeyParams) && Objects.equals(this.custodians, exportSobjectComponentsRequest.custodians) && Objects.equals(this.method, exportSobjectComponentsRequest.method) && Objects.equals(this.description, exportSobjectComponentsRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.wrapKeyParams, this.custodians, this.method, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExportSobjectComponentsRequest {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    wrapKeyParams: ").append(this.toIndentedString(this.wrapKeyParams)).append("\n");
        sb.append("    custodians: ").append(this.toIndentedString(this.custodians)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

