/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Constraints on a portion of a complex tokenization data type.")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FpeConstraints {
    @JsonProperty(value="luhn_check")
    private Boolean luhnCheck = null;
    @JsonProperty(value="num_gt")
    private Integer numGt = null;
    @JsonProperty(value="num_lt")
    private Integer numLt = null;
    @JsonProperty(value="num_ne")
    private List<Integer> numNe = null;
    @JsonProperty(value="date")
    private Object date = null;
    @JsonProperty(value="applies_to")
    private Object appliesTo = null;

    public FpeConstraints luhnCheck(Boolean luhnCheck) {
        this.luhnCheck = luhnCheck;
        return this;
    }

    @ApiModelProperty(value="Whether the token should satisfy the Luhn checksum. It is an error to apply this constraint to non-numeric parts, or for an encrypted part to be under more than one Luhn check constraint. Also, if an encrypted part has a Luhn check constraint applied to it and may contain at least one digit that is not preserved, it must not specify any other constraints. ")
    @JsonProperty(value="luhn_check")
    public Boolean getLuhnCheck() {
        return this.luhnCheck;
    }

    @JsonProperty(value="luhn_check")
    public void setLuhnCheck(Boolean luhnCheck) {
        this.luhnCheck = luhnCheck;
    }

    public FpeConstraints numGt(Integer numGt) {
        this.numGt = numGt;
        return this;
    }

    @ApiModelProperty(value="Number that the token part should be greater than. This constraint can only be specified on (non-compound) numeric encrypted parts that are guaranteed to preserve either everything or nothing at all. ")
    @JsonProperty(value="num_gt")
    public Integer getNumGt() {
        return this.numGt;
    }

    @JsonProperty(value="num_gt")
    public void setNumGt(Integer numGt) {
        this.numGt = numGt;
    }

    public FpeConstraints numLt(Integer numLt) {
        this.numLt = numLt;
        return this;
    }

    @ApiModelProperty(value="Number that the token part should be smaller than. This constraint can only be specified on (non-compound) numeric encrypted parts that are guaranteed to preserve either everything or nothing at all. ")
    @JsonProperty(value="num_lt")
    public Integer getNumLt() {
        return this.numLt;
    }

    @JsonProperty(value="num_lt")
    public void setNumLt(Integer numLt) {
        this.numLt = numLt;
    }

    public FpeConstraints numNe(List<Integer> numNe) {
        this.numNe = numNe;
        return this;
    }

    public FpeConstraints addNumNeItem(Integer numNeItem) {
        if (this.numNe == null) {
            this.numNe = new ArrayList<Integer>();
        }
        this.numNe.add(numNeItem);
        return this;
    }

    @ApiModelProperty(value="Numbers that the token part should not be equal to. It is an error to apply this constraint to non-numeric parts.")
    @JsonProperty(value="num_ne")
    public List<Integer> getNumNe() {
        return this.numNe;
    }

    @JsonProperty(value="num_ne")
    public void setNumNe(List<Integer> numNe) {
        this.numNe = numNe;
    }

    public FpeConstraints date(Object date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Specifies that this portion is supposed to represent a date, or part of one. If used, no other constraints can be specified on this part. This field should either be an `FpeDate` object or an `FpeDatePart` value. ")
    @JsonProperty(value="date")
    public Object getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    public void setDate(Object date) {
        this.date = date;
    }

    public FpeConstraints appliesTo(Object appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    @ApiModelProperty(value="The subparts to apply the constraints to. If not specified, the constraints will be applied to all subparts (recursively). (This can also be explictly indicated by specifying the string \"all\"). If only certain subparts are to be specified, then they should be specified as an `FpeConstraintsApplicabilitySubparts` object. ")
    @JsonProperty(value="applies_to")
    public Object getAppliesTo() {
        return this.appliesTo;
    }

    @JsonProperty(value="applies_to")
    public void setAppliesTo(Object appliesTo) {
        this.appliesTo = appliesTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FpeConstraints fpeConstraints = (FpeConstraints)o;
        return Objects.equals(this.luhnCheck, fpeConstraints.luhnCheck) && Objects.equals(this.numGt, fpeConstraints.numGt) && Objects.equals(this.numLt, fpeConstraints.numLt) && Objects.equals(this.numNe, fpeConstraints.numNe) && Objects.equals(this.date, fpeConstraints.date) && Objects.equals(this.appliesTo, fpeConstraints.appliesTo);
    }

    public int hashCode() {
        return Objects.hash(this.luhnCheck, this.numGt, this.numLt, this.numNe, this.date, this.appliesTo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FpeConstraints {\n");
        sb.append("    luhnCheck: ").append(this.toIndentedString(this.luhnCheck)).append("\n");
        sb.append("    numGt: ").append(this.toIndentedString(this.numGt)).append("\n");
        sb.append("    numLt: ").append(this.toIndentedString(this.numLt)).append("\n");
        sb.append("    numNe: ").append(this.toIndentedString(this.numNe)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    appliesTo: ").append(this.toIndentedString(this.appliesTo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

