/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Language {
    private String value;
    public static final Language LUA = new Language("Lua");
    private static final Map<String, Language> valueMap = new HashMap<String, Language>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private Language(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Language[] values() {
        valueMapLock.lock();
        try {
            Language[] languageArray = valueMap.values().toArray(new Language[valueMap.values().size()]);
            return languageArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static Language fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                Language language = valueMap.get(val);
                return language;
            }
            Language newValue = new Language(val);
            valueMap.put(val, newValue);
            Language language = newValue;
            return language;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("Lua", LUA);
    }
}

