/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TlsMode {
    private String value;
    public static final TlsMode DISABLED = new TlsMode("disabled");
    public static final TlsMode OPPORTUNISTIC = new TlsMode("opportunistic");
    public static final TlsMode REQUIRED = new TlsMode("required");
    private static final Map<String, TlsMode> valueMap = new HashMap<String, TlsMode>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private TlsMode(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TlsMode[] values() {
        valueMapLock.lock();
        try {
            TlsMode[] tlsModeArray = valueMap.values().toArray(new TlsMode[valueMap.values().size()]);
            return tlsModeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static TlsMode fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                TlsMode tlsMode = valueMap.get(val);
                return tlsMode;
            }
            TlsMode newValue = new TlsMode(val);
            valueMap.put(val, newValue);
            TlsMode tlsMode = newValue;
            return tlsMode;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("disabled", DISABLED);
        valueMap.put("opportunistic", OPPORTUNISTIC);
        valueMap.put("required", REQUIRED);
    }
}

