/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.fod.api;

import com.fortify.client.fod.api.AbstractFoDAPI;
import com.fortify.client.fod.api.query.builder.FoDReleasesQueryBuilder;
import com.fortify.client.fod.connection.FoDAuthenticatingRestConnection;
import com.fortify.util.applier.ifblank.IfBlank;
import com.fortify.util.rest.json.JSONMap;
import java.nio.file.CopyOption;
import java.nio.file.Path;

public class FoDReleaseAPI
extends AbstractFoDAPI {
    public FoDReleaseAPI(FoDAuthenticatingRestConnection conn) {
        super(conn);
    }

    public FoDReleasesQueryBuilder queryReleases() {
        return new FoDReleasesQueryBuilder(this.conn());
    }

    public JSONMap getReleaseById(String releaseId) {
        return this.queryReleases().releaseId(IfBlank.ERROR(), releaseId).build().getUnique();
    }

    public JSONMap getReleaseByName(String applicationName, String releaseName) {
        return this.queryReleases().applicationName(IfBlank.ERROR(), applicationName).releaseName(IfBlank.ERROR(), releaseName).build().getUnique();
    }

    public JSONMap getReleaseByNameOrId(String nameOrId, String separator) {
        return this.queryReleases().nameOrId(IfBlank.ERROR(), nameOrId, separator).build().getUnique();
    }

    public JSONMap getReleaseByNameOrId(String nameOrId) {
        return this.queryReleases().nameOrId(IfBlank.ERROR(), nameOrId).build().getUnique();
    }

    public void saveFPR(String releaseId, String scanType, Path outputPath, CopyOption ... copyOptions) {
        this.conn().executeRequestAndSaveResponse("GET", this.conn().getBaseResource().path("/api/v3/releases/{releaseId}/fpr").queryParam("scanType", new Object[]{scanType}).resolveTemplate("releaseId", (Object)releaseId), outputPath, copyOptions);
    }
}

