/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.fod.api.query.builder;

import com.fortify.client.fod.api.FoDApplicationAPI;
import com.fortify.client.fod.api.json.embed.FoDEmbedConfig;
import com.fortify.client.fod.api.json.embed.FoDReleaseEmbedConfig;
import com.fortify.client.fod.api.query.builder.AbstractFoDEntityQueryBuilder;
import com.fortify.client.fod.api.query.builder.FoDOrderBy;
import com.fortify.client.fod.connection.FoDAuthenticatingRestConnection;
import com.fortify.util.applier.ifblank.IfBlank;
import com.fortify.util.applier.ifblank.IfBlankAction;
import com.fortify.util.rest.connection.IRestConnection;
import com.fortify.util.rest.json.JSONMap;
import com.fortify.util.rest.json.embed.StandardEmbedConfig;
import com.fortify.util.rest.json.ondemand.AbstractJSONMapOnDemandLoaderWithConnection;
import com.fortify.util.rest.json.ondemand.IJSONMapOnDemandLoader;
import com.fortify.util.rest.json.preprocessor.IJSONMapPreProcessor;
import com.fortify.util.rest.json.preprocessor.enrich.JSONMapEnrichWithDeepLink;
import com.fortify.util.rest.json.preprocessor.enrich.JSONMapEnrichWithOnDemandProperty;
import org.apache.commons.lang.StringUtils;

public class FoDReleasesQueryBuilder
extends AbstractFoDEntityQueryBuilder<FoDReleasesQueryBuilder>
implements AbstractFoDEntityQueryBuilder.IFoDEntityQueryBuilderParamFields<FoDReleasesQueryBuilder>,
AbstractFoDEntityQueryBuilder.IFoDEntityQueryBuilderParamFilter<FoDReleasesQueryBuilder>,
AbstractFoDEntityQueryBuilder.IFoDEntityQueryBuilderParamOrderByWithDirection<FoDReleasesQueryBuilder> {
    private static final String[] DEEPLINK_FIELDS = new String[]{"releaseId"};

    public FoDReleasesQueryBuilder(FoDAuthenticatingRestConnection conn) {
        super(conn, true);
        this.appendPath("/api/v3/releases");
        this.preProcessor((IJSONMapPreProcessor)new JSONMapEnrichWithDeepLink(conn.getBrowserBaseUrl().toString() + "/redirect/Releases/${releaseId}", DEEPLINK_FIELDS));
    }

    @Override
    protected FoDEmbedConfig.FoDEmbedConfigBuilder<?, ?> createEmbedConfigBuilder() {
        return FoDReleaseEmbedConfig.builder();
    }

    @Override
    public FoDReleasesQueryBuilder paramFields(IfBlankAction ifBlankAction, String ... fields) {
        return (FoDReleasesQueryBuilder)super.paramFields(ifBlankAction, this.replaceField("deepLink", DEEPLINK_FIELDS, fields));
    }

    @Override
    public FoDReleasesQueryBuilder paramFilterAnd(IfBlankAction ifBlankAction, String field, String ... values) {
        return (FoDReleasesQueryBuilder)super.paramFilterAnd(ifBlankAction, field, values);
    }

    @Override
    public FoDReleasesQueryBuilder paramFilterAnd(IfBlankAction ifBlankAction, String filter) {
        return (FoDReleasesQueryBuilder)super.paramFilterAnd(ifBlankAction, filter);
    }

    @Override
    public FoDReleasesQueryBuilder paramOrderBy(IfBlankAction ifBlankAction, FoDOrderBy orderBy) {
        return (FoDReleasesQueryBuilder)super.paramOrderBy(ifBlankAction, orderBy);
    }

    public FoDReleasesQueryBuilder releaseId(IfBlankAction ifBlankAction, String releaseId) {
        return (FoDReleasesQueryBuilder)super.paramFilterAnd(ifBlankAction, "releaseId", releaseId);
    }

    public FoDReleasesQueryBuilder releaseName(IfBlankAction ifBlankAction, String releaseName) {
        return (FoDReleasesQueryBuilder)super.paramFilterAnd(ifBlankAction, "releaseName", releaseName);
    }

    public FoDReleasesQueryBuilder applicationAndOrReleaseName(IfBlankAction ifBlankAction, String applicationAndOrReleaseName) {
        return this.applicationAndOrReleaseName(ifBlankAction, applicationAndOrReleaseName, ":");
    }

    public FoDReleasesQueryBuilder applicationAndOrReleaseName(IfBlankAction ifBlankAction, String applicationAndOrReleaseName, String separator) {
        ifBlankAction.apply("applicationAndOrReleaseName", (Object)applicationAndOrReleaseName, StringUtils::isBlank, v -> {
            String[] elts = v.split(separator);
            if (elts.length == 1 && StringUtils.isNotBlank((String)elts[0]) || elts.length == 2 && StringUtils.isBlank((String)elts[1])) {
                this.applicationName(IfBlank.ERROR(), elts[0]);
            } else if (elts.length == 2 && StringUtils.isBlank((String)elts[0])) {
                this.releaseName(IfBlank.ERROR(), elts[1]);
            } else if (elts.length == 2) {
                this.applicationName(IfBlank.ERROR(), elts[0]).releaseName(IfBlank.ERROR(), elts[1]);
            } else {
                throw new IllegalArgumentException("Applications or releases containing a '" + separator + "' are unsupported");
            }
        });
        return (FoDReleasesQueryBuilder)this._this();
    }

    public FoDReleasesQueryBuilder applicationAndReleaseName(IfBlankAction ifBlankAction, String applicationName, String releaseName) {
        return this.applicationName(ifBlankAction, applicationName).releaseName(ifBlankAction, releaseName);
    }

    public FoDReleasesQueryBuilder applicationId(IfBlankAction ifBlankAction, String applicationId) {
        return (FoDReleasesQueryBuilder)super.paramFilterAnd(ifBlankAction, "applicationId", applicationId);
    }

    public FoDReleasesQueryBuilder applicationName(IfBlankAction ifBlankAction, String applicationName) {
        return (FoDReleasesQueryBuilder)super.paramFilterAnd(ifBlankAction, "applicationName", applicationName);
    }

    public FoDReleasesQueryBuilder nameOrId(IfBlankAction ifBlankAction, String applicationAndReleaseNameOrId, String separator) {
        ifBlankAction.apply("applicationAndReleaseNameOrId", (Object)applicationAndReleaseNameOrId, StringUtils::isBlank, v -> {
            String[] appVersionElements = v.split(separator);
            if (appVersionElements.length == 1) {
                this.releaseId(IfBlank.ERROR(), appVersionElements[0]);
            } else if (appVersionElements.length == 2) {
                this.applicationAndReleaseName(IfBlank.ERROR(), appVersionElements[0], appVersionElements[1]);
            } else {
                throw new IllegalArgumentException("Applications or releases containing a '+separator+' can only be specified by id");
            }
        });
        return (FoDReleasesQueryBuilder)this._this();
    }

    public FoDReleasesQueryBuilder nameOrId(IfBlankAction ifBlankAction, String applicationAndReleaseNameOrId) {
        return this.nameOrId(ifBlankAction, applicationAndReleaseNameOrId, ":");
    }

    public FoDReleasesQueryBuilder rating(IfBlankAction ifBlankAction, Integer rating) {
        return (FoDReleasesQueryBuilder)super.paramFilterAnd(ifBlankAction, "rating", rating + "");
    }

    public FoDReleasesQueryBuilder sdlcStatusType(IfBlankAction ifBlankAction, String sdlcStatusType) {
        return (FoDReleasesQueryBuilder)super.paramFilterAnd(ifBlankAction, "sdlcStatusType", sdlcStatusType);
    }

    public FoDReleasesQueryBuilder isPassed(IfBlankAction ifBlankAction, Boolean isPassed) {
        return (FoDReleasesQueryBuilder)super.paramFilterAnd(ifBlankAction, "isPassed", Boolean.toString(isPassed));
    }

    public FoDReleasesQueryBuilder embed(FoDEmbedConfig embedConfig) {
        if ("application".equals(embedConfig.getSubEntity())) {
            return this.onDemandApplication(embedConfig.getPropertyName());
        }
        return (FoDReleasesQueryBuilder)super.embed((StandardEmbedConfig)embedConfig);
    }

    public FoDReleasesQueryBuilder onDemandAll() {
        return this.onDemandApplication();
    }

    public FoDReleasesQueryBuilder onDemandApplication() {
        return this.onDemandApplication("application");
    }

    public FoDReleasesQueryBuilder onDemandApplication(String propertyName) {
        return (FoDReleasesQueryBuilder)this.preProcessor((IJSONMapPreProcessor)new JSONMapEnrichWithOnDemandProperty(propertyName, (IJSONMapOnDemandLoader)new FoDApplicationOnDemandLoader((FoDAuthenticatingRestConnection)this.getConn())));
    }

    public FoDReleasesQueryBuilder onDemandSubEntity(String entityName) {
        return this.onDemandSubEntity(entityName, entityName);
    }

    public FoDReleasesQueryBuilder onDemandSubEntity(String propertyName, String subEntity) {
        switch (subEntity) {
            case "application": {
                return this.onDemandApplication();
            }
        }
        return (FoDReleasesQueryBuilder)this.embedSubEntity(propertyName, subEntity, new String[0]);
    }

    private static class FoDApplicationOnDemandLoader
    extends AbstractJSONMapOnDemandLoaderWithConnection<FoDAuthenticatingRestConnection> {
        private static final long serialVersionUID = 1L;

        public FoDApplicationOnDemandLoader(FoDAuthenticatingRestConnection conn) {
            super((IRestConnection)conn, true);
        }

        public Object getOnDemand(FoDAuthenticatingRestConnection conn, String propertyName, JSONMap parent) {
            return ((FoDApplicationAPI)conn.api(FoDApplicationAPI.class)).queryApplications().applicationId(IfBlank.ERROR(), (String)parent.get((Object)"applicationId", String.class)).onDemandAttributesMap().onDemandBugTracker().build().getUnique();
        }

        protected Class<FoDAuthenticatingRestConnection> getConnectionClazz() {
            return FoDAuthenticatingRestConnection.class;
        }
    }
}

