/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.fod.connection;

import com.fortify.client.fod.connection.FoDBasicRestConnection;
import com.fortify.client.fod.connection.FoDRestConnectionConfig;
import com.fortify.client.fod.connection.FoDTokenFactory;
import com.fortify.util.rest.connection.IRestConnectionBuilder;
import java.net.URI;
import java.time.ZoneId;
import javax.ws.rs.client.Invocation;

public class FoDAuthenticatingRestConnection
extends FoDBasicRestConnection {
    private final FoDTokenFactory tokenProvider;
    private final URI browserBaseUrl;
    private final String instanceName;
    private final ZoneId serverZoneId;

    public FoDAuthenticatingRestConnection(FoDRestConnectionConfig<?> config) {
        super(config);
        this.browserBaseUrl = config.getBrowserBaseUrl();
        this.instanceName = config.getInstanceName();
        this.serverZoneId = config.getServerZoneId();
        this.tokenProvider = new FoDTokenFactory(config);
    }

    public void close() {
        super.close();
        this.tokenProvider.close();
    }

    @Override
    public Invocation.Builder updateBuilder(Invocation.Builder builder) {
        String token = this.isMultiThreaded() ? this.tokenProvider.getTokenSynchronized() : this.tokenProvider.getToken();
        return super.updateBuilder(builder).header("Authorization", (Object)("Bearer " + token));
    }

    public static final FoDAuthenticatingRestConnectionBuilder builder() {
        return new FoDAuthenticatingRestConnectionBuilder();
    }

    public URI getBrowserBaseUrl() {
        return this.browserBaseUrl;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public ZoneId getServerZoneId() {
        return this.serverZoneId;
    }

    public static class FoDAuthenticatingRestConnectionBuilder
    extends FoDRestConnectionConfig<FoDAuthenticatingRestConnectionBuilder>
    implements IRestConnectionBuilder<FoDAuthenticatingRestConnection> {
        public FoDAuthenticatingRestConnection build() {
            return new FoDAuthenticatingRestConnection(this);
        }
    }
}

