/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.fod.connection;

import com.fortify.client.fod.connection.FoDRestConnectionConfig;
import com.fortify.util.rest.connection.AbstractRestConnection;
import com.fortify.util.rest.connection.TooManyRequestsRetryStrategy;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.apache.http.client.ServiceUnavailableRetryStrategy;

public class FoDBasicRestConnection
extends AbstractRestConnection {
    private final Map<String, Object> pathMutexes = new HashMap<String, Object>();
    private final int rateLimitMaxRetries;

    protected FoDBasicRestConnection(FoDRestConnectionConfig<?> config) {
        super(config);
        this.rateLimitMaxRetries = config.getRateLimitMaxRetries();
    }

    protected final Object getMutex(String path) {
        String pathWithoutIds = path.replaceAll("\\d", "x");
        return this.pathMutexes.computeIfAbsent(pathWithoutIds, key -> new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T executeRequestWithFinalizedWebTarget(String httpMethod, WebTarget webResource, Entity<?> entity, Class<T> returnType) {
        if (!this.isMultiThreaded()) {
            return (T)super.executeRequestWithFinalizedWebTarget(httpMethod, webResource, entity, returnType);
        }
        Object object = this.getMutex(webResource.getUri().getPath());
        synchronized (object) {
            return (T)super.executeRequestWithFinalizedWebTarget(httpMethod, webResource, entity, returnType);
        }
    }

    public Invocation.Builder updateBuilder(Invocation.Builder builder) {
        return super.updateBuilder(builder).accept(new String[]{"application/json"});
    }

    protected ServiceUnavailableRetryStrategy getServiceUnavailableRetryStrategy() {
        return new TooManyRequestsRetryStrategy().retryAfterHeaderName("X-Rate-Limit-Reset").logPrefix("[FoD]").maxRetries(this.rateLimitMaxRetries);
    }
}

