/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.fod.connection;

import com.fortify.util.rest.connection.AbstractRestConnectionWithUsernamePasswordConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Form;
import org.apache.commons.lang.StringUtils;

public class FoDRestConnectionConfig<T extends FoDRestConnectionConfig<T>>
extends AbstractRestConnectionWithUsernamePasswordConfig<T> {
    private static final Map<String, ZoneId> instanceToZoneNames = FoDRestConnectionConfig._getInstanceToZoneNames();
    private String[] scopes = new String[]{"api-tenant"};
    private String clientId;
    private String clientSecret;
    private String tenant;
    private URI browserBaseUrl;
    private String instanceName;
    private ZoneId serverZoneId;
    private int rateLimitMaxRetries = 1;

    public T clientId(String clientId) {
        this.setClientId(clientId);
        return (T)((Object)((FoDRestConnectionConfig)this.getThis()));
    }

    public T clientSecret(String clientSecret) {
        this.setClientSecret(clientSecret);
        return (T)((Object)((FoDRestConnectionConfig)this.getThis()));
    }

    public T tenant(String tenant) {
        this.setTenant(tenant);
        return (T)((Object)((FoDRestConnectionConfig)this.getThis()));
    }

    public T scopes(String ... scopes) {
        this.setScopes(scopes);
        return (T)((Object)((FoDRestConnectionConfig)this.getThis()));
    }

    public T rateLimitMaxRetries(int rateLimitMaxRetries) {
        this.setRateLimitMaxRetries(rateLimitMaxRetries);
        return (T)((Object)((FoDRestConnectionConfig)this.getThis()));
    }

    public T serverZoneId(ZoneId zoneId) {
        this.setServerZoneId(zoneId);
        return (T)((Object)((FoDRestConnectionConfig)this.getThis()));
    }

    public String getUserNameWithTenant() {
        return this.getTenant() + "\\" + this.getUserName();
    }

    public void setScopes(String ... scopes) {
        this.scopes = scopes;
    }

    protected void setBaseUrl(URI uri) {
        try {
            URI browserUrl;
            URI apiUrl;
            if (uri.getHost().startsWith("api.")) {
                apiUrl = uri;
                browserUrl = new URI(uri.getScheme(), null, uri.getHost().substring("api.".length()), uri.getPort(), uri.getPath(), uri.getQuery(), null);
            } else {
                apiUrl = new URI(uri.getScheme(), null, "api." + uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
                browserUrl = uri;
            }
            super.setBaseUrl(apiUrl);
            this.setBrowserBaseUrl(browserUrl);
            String instanceName = StringUtils.substringBefore((String)browserUrl.getHost(), (String)".");
            ZoneId serverZoneId = this.serverZoneId != null ? this.serverZoneId : instanceToZoneNames.getOrDefault(instanceName, ZoneId.systemDefault());
            this.setInstanceName(instanceName);
            this.setServerZoneId(serverZoneId);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error constructing URI");
        }
    }

    public void setServerZoneId(ZoneId zoneId) {
        this.serverZoneId = zoneId;
    }

    public void setServerZoneId(String zoneId) {
        this.setServerZoneId(ZoneId.of(zoneId));
    }

    public ZoneId getServerZoneId() {
        return this.serverZoneId == null ? ZoneId.systemDefault() : this.serverZoneId;
    }

    Form getAuth() {
        if (StringUtils.isNotBlank((String)this.getClientId()) && StringUtils.isNotBlank((String)this.getClientSecret())) {
            return this.getAuthClientCredentials();
        }
        if (StringUtils.isNotBlank((String)this.getTenant()) && StringUtils.isNotBlank((String)this.getUserName()) && StringUtils.isNotBlank((String)this.getPassword())) {
            return this.getAuthUserCredentials();
        }
        throw new RuntimeException("Either client id and secret, or tenant, user name and password must be specified");
    }

    protected void parseUriUserInfo(String userInfo) {
        if (userInfo != null) {
            String user = null;
            String password = null;
            String[] userInfoParts = userInfo.split(":", 2);
            if (userInfoParts.length > 0) {
                user = userInfoParts[0];
            }
            if (userInfoParts.length > 1) {
                password = userInfoParts[1];
            }
            if (StringUtils.isNotBlank((String)user)) {
                String[] userParts = user.split("\\\\", 2);
                if (userParts.length == 2) {
                    this.setTenant(userParts[0]);
                    this.setUserName(userParts[1]);
                    this.setPassword(password);
                } else {
                    this.setClientId(user);
                    this.setClientSecret(password);
                }
            }
        }
    }

    private Form getAuthClientCredentials() {
        Form form = new Form();
        form.param("scope", this.getScope());
        form.param("grant_type", "client_credentials");
        form.param("client_id", this.getClientId());
        form.param("client_secret", this.getClientSecret());
        return form;
    }

    private Form getAuthUserCredentials() {
        Form form = new Form();
        form.param("scope", this.getScope());
        form.param("grant_type", "password");
        form.param("username", this.getUserNameWithTenant());
        form.param("password", this.getPassword());
        return form;
    }

    private String getScope() {
        return StringUtils.join((Object[])this.getScopes(), (char)' ');
    }

    private static Map<String, ZoneId> _getInstanceToZoneNames() {
        HashMap<String, ZoneId> result = new HashMap<String, ZoneId>();
        result.put("ams", ZoneId.of("America/Los_Angeles"));
        result.put("emea", ZoneId.of("Europe/London"));
        result.put("apac", ZoneId.of("Etc/UTC"));
        result.put("fed", ZoneId.of("Etc/UTC"));
        return result;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getTenant() {
        return this.tenant;
    }

    public URI getBrowserBaseUrl() {
        return this.browserBaseUrl;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public int getRateLimitMaxRetries() {
        return this.rateLimitMaxRetries;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setRateLimitMaxRetries(int rateLimitMaxRetries) {
        this.rateLimitMaxRetries = rateLimitMaxRetries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FoDRestConnectionConfig)) {
            return false;
        }
        FoDRestConnectionConfig other = (FoDRestConnectionConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getRateLimitMaxRetries() != other.getRateLimitMaxRetries()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScopes(), other.getScopes())) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        URI this$browserBaseUrl = this.getBrowserBaseUrl();
        URI other$browserBaseUrl = other.getBrowserBaseUrl();
        if (this$browserBaseUrl == null ? other$browserBaseUrl != null : !((Object)this$browserBaseUrl).equals(other$browserBaseUrl)) {
            return false;
        }
        String this$instanceName = this.getInstanceName();
        String other$instanceName = other.getInstanceName();
        if (this$instanceName == null ? other$instanceName != null : !this$instanceName.equals(other$instanceName)) {
            return false;
        }
        ZoneId this$serverZoneId = this.getServerZoneId();
        ZoneId other$serverZoneId = other.getServerZoneId();
        return !(this$serverZoneId == null ? other$serverZoneId != null : !((Object)this$serverZoneId).equals(other$serverZoneId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FoDRestConnectionConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getRateLimitMaxRetries();
        result = result * 59 + Arrays.deepHashCode(this.getScopes());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        URI $browserBaseUrl = this.getBrowserBaseUrl();
        result = result * 59 + ($browserBaseUrl == null ? 43 : ((Object)$browserBaseUrl).hashCode());
        String $instanceName = this.getInstanceName();
        result = result * 59 + ($instanceName == null ? 43 : $instanceName.hashCode());
        ZoneId $serverZoneId = this.getServerZoneId();
        result = result * 59 + ($serverZoneId == null ? 43 : ((Object)$serverZoneId).hashCode());
        return result;
    }

    public String toString() {
        return "FoDRestConnectionConfig(super=" + super.toString() + ", scopes=" + Arrays.deepToString(this.getScopes()) + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", tenant=" + this.getTenant() + ", browserBaseUrl=" + this.getBrowserBaseUrl() + ", instanceName=" + this.getInstanceName() + ", serverZoneId=" + this.getServerZoneId() + ", rateLimitMaxRetries=" + this.getRateLimitMaxRetries() + ")";
    }

    private void setBrowserBaseUrl(URI browserBaseUrl) {
        this.browserBaseUrl = browserBaseUrl;
    }

    private void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }
}

