/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.fod.connection;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortify.client.fod.connection.FoDBasicRestConnection;
import com.fortify.client.fod.connection.FoDRestConnectionConfig;
import com.fortify.util.log4j.LogMaskingHelper;
import java.io.Closeable;
import java.util.Date;
import java.util.regex.Pattern;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FoDTokenFactory
implements Closeable {
    static final Log LOG = LogFactory.getLog(FoDTokenFactory.class);
    private static final Pattern EXPR_TOKEN = Pattern.compile("\"access_token\":\"([^\"]+)\"");
    private static final Pattern EXPR_PASSWORD = Pattern.compile("password=([^\\s&]+)");
    private final FoDBasicRestConnection basicConn;
    private final Form auth;
    private TokenData tokenData = null;

    public FoDTokenFactory(FoDRestConnectionConfig<?> config) {
        this.basicConn = new FoDBasicRestConnection(config);
        this.auth = config.getAuth();
    }

    @Override
    public void close() {
        this.basicConn.close();
    }

    public synchronized String getTokenSynchronized() {
        return this.getToken();
    }

    public String getToken() {
        if (this.tokenData == null || this.tokenData.isExpired()) {
            LogMaskingHelper.maskByPatternGroups().patterns(new Pattern[]{EXPR_TOKEN, EXPR_PASSWORD}).on(() -> {
                this.tokenData = (TokenData)this.basicConn.executeRequest("POST", this.basicConn.getBaseResource().path("/oauth/token"), Entity.entity((Object)this.auth, (String)"application/x-www-form-urlencoded"), TokenData.class);
                return this.tokenData;
            });
            LOG.info((Object)("[FoD] Obtained access token, expiring at " + new Date(this.tokenData.getExpiresAt()).toString()));
        }
        return this.tokenData.getAccessToken();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class TokenData {
        private String accessToken;
        private long expiresAt;

        private TokenData() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        @JsonProperty(value="access_token")
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @JsonProperty(value="expires_in")
        public void setExpiresIn(long expiresIn) {
            this.expiresAt = new Date().getTime() + (expiresIn - 5L) * 1000L;
        }

        public long getExpiresAt() {
            return this.expiresAt;
        }

        public boolean isExpired() {
            return new Date().getTime() > this.expiresAt;
        }
    }
}

