/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.SSCApplicationVersionAttributeAPI;
import com.fortify.client.ssc.api.SSCAttributeDefinitionAPI;
import com.fortify.client.ssc.api.SSCAuthEntityAPI;
import com.fortify.client.ssc.api.SSCIssueTemplateAPI;
import com.fortify.client.ssc.api.query.builder.SSCApplicationVersionsOfAuthEntityQueryBuilder;
import com.fortify.client.ssc.api.query.builder.SSCApplicationVersionsQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.applier.ifblank.IfBlank;
import com.fortify.util.rest.json.JSONMap;
import java.util.Map;
import javax.ws.rs.client.Entity;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class SSCApplicationVersionAPI
extends AbstractSSCAPI {
    public SSCApplicationVersionAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCApplicationVersionsQueryBuilder queryApplicationVersions() {
        return new SSCApplicationVersionsQueryBuilder(this.conn());
    }

    public SSCApplicationVersionsOfAuthEntityQueryBuilder queryApplicationVersionsByAuthEntityId(String authEntityId) {
        return new SSCApplicationVersionsOfAuthEntityQueryBuilder(this.conn(), authEntityId);
    }

    public SSCApplicationVersionsOfAuthEntityQueryBuilder queryApplicationVersionsByAuthEntityName(String authEntityName) {
        return this.queryApplicationVersionsByAuthEntityId(((SSCAuthEntityAPI)this.conn().api(SSCAuthEntityAPI.class)).getAuthEntityIdByEntityName(authEntityName));
    }

    public JSONMap getApplicationVersionById(String applicationVersionId) {
        return this.queryApplicationVersions().id(IfBlank.ERROR(), applicationVersionId).build().getUnique();
    }

    public JSONMap getApplicationVersionByName(String applicationName, String versionName) {
        return this.queryApplicationVersions().applicationName(IfBlank.ERROR(), applicationName).versionName(IfBlank.ERROR(), versionName).build().getUnique();
    }

    public JSONMap getApplicationVersionByNameOrId(String nameOrId, String separator) {
        return this.queryApplicationVersions().nameOrId(IfBlank.ERROR(), nameOrId, separator).build().getUnique();
    }

    public JSONMap getApplicationVersionByNameOrId(String nameOrId) {
        return this.queryApplicationVersions().nameOrId(IfBlank.ERROR(), nameOrId).build().getUnique();
    }

    public void deleteApplicationVersion(JSONMap applicationVersion) {
        this.deleteApplicationVersionById((String)applicationVersion.get((Object)"id", String.class));
    }

    @SSCRequiredActionsPermitted(value={"DELETE=/api/v\\d+/projectVersions/\\d+"})
    public void deleteApplicationVersionById(String applicationVersionId) {
        this.conn().executeRequest("DELETE", this.conn().getBaseResource().path("/api/v1/projectVersions").path(applicationVersionId), Void.class);
    }

    public CreateApplicationVersionBuilder createApplicationVersion() {
        return new CreateApplicationVersionBuilder();
    }

    public final class CreateApplicationVersionBuilder {
        private SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper attributeDefinitionHelper;
        private SSCIssueTemplateAPI.SSCIssueTemplateHelper issueTemplateHelper;
        private String applicationName;
        private String applicationId;
        private String applicationDescription;
        private String versionName;
        private String versionDescription;
        private String issueTemplateId;
        private boolean autoAddRequiredAttributes;
        private LinkedMultiValueMap<String, Object> attributeNameOrIdToValueMap = new LinkedMultiValueMap();

        private CreateApplicationVersionBuilder() {
        }

        public CreateApplicationVersionBuilder withAttributeDefinitionHelper(SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper attributeDefinitionHelper) {
            this.attributeDefinitionHelper = attributeDefinitionHelper;
            return this;
        }

        public CreateApplicationVersionBuilder withIssueTemplateHelper(SSCIssueTemplateAPI.SSCIssueTemplateHelper issueTemplateHelper) {
            this.issueTemplateHelper = issueTemplateHelper;
            return this;
        }

        public CreateApplicationVersionBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public CreateApplicationVersionBuilder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public CreateApplicationVersionBuilder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public CreateApplicationVersionBuilder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public CreateApplicationVersionBuilder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public CreateApplicationVersionBuilder autoAddRequiredAttributes(boolean autoAddRequiredAttributes) {
            this.autoAddRequiredAttributes = autoAddRequiredAttributes;
            return this;
        }

        public CreateApplicationVersionBuilder issueTemplateName(String issueTemplateName) {
            this.issueTemplateId = this.getIssueTemplateHelper().getIssueTemplateIdForName(issueTemplateName);
            if (this.issueTemplateId == null) {
                throw new IllegalArgumentException("Unknown issue template " + issueTemplateName);
            }
            return this;
        }

        public CreateApplicationVersionBuilder attribute(String attributeNameOrId, String attributeValue) {
            this.attributeNameOrIdToValueMap.add((Object)attributeNameOrId, (Object)attributeValue);
            return this;
        }

        public CreateApplicationVersionBuilder attributes(MultiValueMap<String, Object> values) {
            this.attributeNameOrIdToValueMap.addAll(values);
            return this;
        }

        public String execute() {
            MultiValueMap<String, Object> attributes = this.getApplicationVersionAttributes();
            String applicationVersionId = (String)this.createNonCommittedApplicationVersiom().get((Object)"id", String.class);
            ((SSCApplicationVersionAttributeAPI)SSCApplicationVersionAPI.this.conn().api(SSCApplicationVersionAttributeAPI.class)).updateApplicationVersionAttributes(applicationVersionId).withAttributeDefinitionHelper(this.getAttributeDefinitionHelper()).byNameOrId(attributes).execute();
            this.commitApplicationVersion(applicationVersionId);
            return applicationVersionId;
        }

        @SSCRequiredActionsPermitted(value={"POST=/api/v\\d+/projectVersions"})
        private JSONMap createNonCommittedApplicationVersiom() {
            JSONMap data = new JSONMap();
            data.put((Object)"name", (Object)this.versionName);
            data.put((Object)"description", (Object)(this.versionDescription == null ? "" : this.versionDescription));
            data.put((Object)"project", (Object)this.getExistingOrNewApplicationData());
            data.put((Object)"active", (Object)true);
            data.put((Object)"committed", (Object)false);
            data.put((Object)"issueTemplateId", (Object)this.getIssueTemplateId());
            return ((JSONMap)SSCApplicationVersionAPI.this.conn().executeRequest("POST", SSCApplicationVersionAPI.this.conn().getBaseResource().path("/api/v1/projectVersions"), Entity.entity((Object)data, (String)"application/json"), JSONMap.class)).getOrCreateJSONMap("data");
        }

        private String getIssueTemplateId() {
            String string = this.issueTemplateId = this.issueTemplateId != null ? this.issueTemplateId : this.getIssueTemplateHelper().getDefaultIssueTemplateId();
            if (this.issueTemplateId == null) {
                throw new IllegalStateException("No issue template specified, and no default issue template configured on SSC");
            }
            return this.issueTemplateId;
        }

        private MultiValueMap<String, Object> getApplicationVersionAttributes() {
            LinkedMultiValueMap data = new LinkedMultiValueMap();
            if (this.autoAddRequiredAttributes) {
                data.putAll(this.getAttributeDefinitionHelper().getRequiredAttributesWithDefaultValues());
            }
            if (this.attributeNameOrIdToValueMap != null) {
                data.putAll(this.attributeNameOrIdToValueMap);
            }
            return data;
        }

        @SSCRequiredActionsPermitted(value={"PUT=/api/v\\d+/projectVersions/\\d+"})
        private void commitApplicationVersion(String applicationVersionId) {
            JSONMap data = new JSONMap();
            data.put((Object)"committed", (Object)true);
            SSCApplicationVersionAPI.this.conn().executeRequest("PUT", SSCApplicationVersionAPI.this.conn().getBaseResource().path("/api/v1/projectVersions").path(applicationVersionId), Entity.entity((Object)data, (String)"application/json"), JSONMap.class);
        }

        private final JSONMap getExistingOrNewApplicationData() {
            if (StringUtils.isBlank((String)this.applicationName) && StringUtils.isBlank((String)this.applicationId)) {
                throw new IllegalStateException("Either application name or id must be specified");
            }
            JSONMap result = ((SSCApplicationVersionsQueryBuilder)((SSCApplicationVersionAPI)SSCApplicationVersionAPI.this.conn().api(SSCApplicationVersionAPI.class)).queryApplicationVersions().applicationName(IfBlank.SKIP(), this.applicationName).applicationId(IfBlank.SKIP(), this.applicationId).maxResults(1)).paramFields("project").build().getUnique();
            return result == null ? this.getNewApplicationData() : this.getExistingApplicationData((JSONMap)result.get((Object)"project", JSONMap.class));
        }

        private JSONMap getNewApplicationData() {
            JSONMap result = new JSONMap();
            result.put((Object)"name", (Object)this.applicationName);
            result.put((Object)"issueTemplateId", (Object)this.issueTemplateId);
            result.put((Object)"description", (Object)this.applicationDescription);
            return result;
        }

        private JSONMap getExistingApplicationData(JSONMap existingApplication) {
            return new JSONMap((Map)existingApplication, "name", new String[]{"id", "issueTemplateId", "description"});
        }

        private SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper getAttributeDefinitionHelper() {
            if (this.attributeDefinitionHelper == null) {
                this.attributeDefinitionHelper = ((SSCAttributeDefinitionAPI)SSCApplicationVersionAPI.this.conn().api(SSCAttributeDefinitionAPI.class)).getAttributeDefinitionHelper();
            }
            return this.attributeDefinitionHelper;
        }

        private SSCIssueTemplateAPI.SSCIssueTemplateHelper getIssueTemplateHelper() {
            if (this.issueTemplateHelper == null) {
                this.issueTemplateHelper = ((SSCIssueTemplateAPI)SSCApplicationVersionAPI.this.conn().api(SSCIssueTemplateAPI.class)).getIssueTemplateHelper();
            }
            return this.issueTemplateHelper;
        }
    }
}

