/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.SSCAttributeDefinitionAPI;
import com.fortify.client.ssc.api.query.builder.SSCApplicationVersionAttributesQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONList;
import com.fortify.util.rest.json.JSONMap;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import org.springframework.util.MultiValueMap;

public class SSCApplicationVersionAttributeAPI
extends AbstractSSCAPI {
    public SSCApplicationVersionAttributeAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCApplicationVersionAttributesQueryBuilder queryApplicationVersionAttributes(String applicationVersionId) {
        return new SSCApplicationVersionAttributesQueryBuilder(this.conn(), applicationVersionId);
    }

    public JSONList getApplicationVersionAttributes(String applicationVersionId, String ... fields) {
        return this.queryApplicationVersionAttributes(applicationVersionId).paramFields(fields).build().getAll();
    }

    public SSCApplicationVersionAttributesUpdater updateApplicationVersionAttributes(String applicationVersionId) {
        return new SSCApplicationVersionAttributesUpdater(applicationVersionId);
    }

    public final class SSCApplicationVersionAttributesUpdater {
        private final String applicationVersionId;
        private final JSONList requestData = new JSONList();
        private SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper attributeDefinitionHelper;
        private JSONMap attributeDefinitionsByNameOrId;

        private SSCApplicationVersionAttributesUpdater(String applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public SSCApplicationVersionAttributesUpdater withAttributeDefinitionHelper(SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper attributeDefinitionHelper) {
            this.attributeDefinitionHelper = attributeDefinitionHelper;
            return this;
        }

        public SSCApplicationVersionAttributesUpdater byNameOrId(String attributeNameOrId, List<Object> attributeValues) {
            JSONMap attributeDefinition = (JSONMap)this.getAttributeDefinitionsByNameOrId().get((Object)attributeNameOrId, JSONMap.class);
            if (attributeDefinition == null) {
                throw new IllegalArgumentException("Attribute name or id " + attributeNameOrId + " does not exist");
            }
            JSONMap attributeData = new JSONMap();
            attributeData.put((Object)"attributeDefinitionId", attributeDefinition.get((Object)"id"));
            String type = (String)attributeDefinition.get((Object)"type", String.class);
            if (!"MULTIPLE".equals(type) && attributeValues != null && attributeValues.size() > 1) {
                throw new IllegalArgumentException("Attribute " + attributeNameOrId + " can only contain a single value");
            }
            if ("MULTIPLE".equals(type) || "SINGLE".equals(type)) {
                attributeData.put((Object)"values", (Object)this.getGuidValuesList(attributeDefinition, attributeNameOrId, attributeValues));
                attributeData.put((Object)"value", null);
            } else {
                attributeData.put((Object)"values", null);
                attributeData.put((Object)"value", this.getSimpleValue(attributeValues));
            }
            this.requestData.add((Object)attributeData);
            return this;
        }

        public SSCApplicationVersionAttributesUpdater byNameOrId(MultiValueMap<String, Object> attributeNameOrIdToValuesMap) {
            for (Map.Entry entry : attributeNameOrIdToValuesMap.entrySet()) {
                this.byNameOrId((String)entry.getKey(), (List)entry.getValue());
            }
            return this;
        }

        @SSCRequiredActionsPermitted(value={"PUT=/api/v\\d+/projectVersions/\\d+/attributes"})
        public JSONList execute() {
            JSONMap result = (JSONMap)SSCApplicationVersionAttributeAPI.this.conn().executeRequest("PUT", SSCApplicationVersionAttributeAPI.this.conn().getBaseResource().path("/api/v1/projectVersions").path(this.applicationVersionId).path("attributes"), Entity.entity((Object)this.requestData, (String)"application/json"), JSONMap.class);
            return (JSONList)result.get((Object)"data", JSONList.class);
        }

        private SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper getAttributeDefinitionHelper() {
            if (this.attributeDefinitionHelper == null) {
                this.attributeDefinitionHelper = ((SSCAttributeDefinitionAPI)SSCApplicationVersionAttributeAPI.this.conn().api(SSCAttributeDefinitionAPI.class)).getAttributeDefinitionHelper();
            }
            return this.attributeDefinitionHelper;
        }

        private JSONMap getAttributeDefinitionsByNameOrId() {
            if (this.attributeDefinitionsByNameOrId == null) {
                this.attributeDefinitionsByNameOrId = this.getAttributeDefinitionHelper().getAttributeDefinitionsByNameAndId();
            }
            return this.attributeDefinitionsByNameOrId;
        }

        private Object getSimpleValue(List<Object> attributeValues) {
            Object value;
            Object object = value = attributeValues == null ? null : attributeValues.get(0);
            if (value != null && value instanceof Date) {
                Date valueDate = (Date)value;
                value = new SimpleDateFormat("yyyy-MM-dd").format(valueDate);
            }
            return value;
        }

        private JSONList getGuidValuesList(JSONMap attributeDefinition, String attributeNameOrId, List<Object> attributeValues) {
            JSONMap optionsByNameAndGuid = (JSONMap)attributeDefinition.get((Object)"optionsByNameAndGuid", JSONMap.class);
            JSONList values = new JSONList();
            for (Object optionValueOrGuid : attributeValues) {
                JSONMap option = (JSONMap)optionsByNameAndGuid.get(optionValueOrGuid, JSONMap.class);
                if (option == null) {
                    throw new IllegalArgumentException("Invalid option " + optionValueOrGuid + " for attribute " + attributeNameOrId);
                }
                JSONMap value = new JSONMap();
                value.put((Object)"guid", option.get((Object)"guid", String.class));
                values.add((Object)value);
            }
            return values;
        }
    }
}

