/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.SSCFileUpDownloadAPI;
import com.fortify.client.ssc.api.SSCJobAPI;
import com.fortify.client.ssc.api.query.builder.SSCApplicationVersionArtifactsQueryBuilder;
import com.fortify.client.ssc.api.query.builder.SSCArtifactByIdQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONMap;
import com.fortify.util.spring.expression.helper.InternalExpressionHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;

public class SSCArtifactAPI
extends AbstractSSCAPI {
    public SSCArtifactAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCApplicationVersionArtifactsQueryBuilder queryArtifacts(String applicationVersionId) {
        return new SSCApplicationVersionArtifactsQueryBuilder(this.conn(), applicationVersionId);
    }

    public SSCArtifactByIdQueryBuilder queryArtifactById(String artifactId) {
        return new SSCArtifactByIdQueryBuilder(this.conn(), artifactId);
    }

    public final JSONMap getArtifactById(String artifactId, String ... fields) {
        return this.queryArtifactById(artifactId).paramFields(fields).build().getUnique();
    }

    @SSCRequiredActionsPermitted(value={"POST=/download/currentStateFprDownload.html"})
    public final long downloadApplicationFile(String applicationVersionId, Path target, boolean includeSource) {
        WebTarget webTarget = this.conn().getBaseResource().path("/download/currentStateFprDownload.html").queryParam("id", new Object[]{"" + applicationVersionId}).queryParam("includeSource", new Object[]{includeSource});
        return ((SSCFileUpDownloadAPI)this.conn().api(SSCFileUpDownloadAPI.class)).downloadFile(webTarget, SSCFileUpDownloadAPI.FileTokenType.DOWNLOAD, target);
    }

    @SSCRequiredActionsPermitted(value={"POST=/download/artifactDownload.html"})
    public final long downloadArtifact(String artifactId, Path target) {
        WebTarget webTarget = this.conn().getBaseResource().path("/download/artifactDownload.html").queryParam("id", new Object[]{"" + artifactId});
        return ((SSCFileUpDownloadAPI)this.conn().api(SSCFileUpDownloadAPI.class)).downloadFile(webTarget, SSCFileUpDownloadAPI.FileTokenType.DOWNLOAD, target);
    }

    @SSCRequiredActionsPermitted(value={"POST=/upload/resultFileUpload.html"})
    public final JSONMap uploadArtifact(String applicationVersionId, File fprFile) {
        WebTarget webTarget = this.conn().getBaseResource().path("/upload/resultFileUpload.html").queryParam("entityId", new Object[]{"" + applicationVersionId});
        return ((SSCFileUpDownloadAPI)this.conn().api(SSCFileUpDownloadAPI.class)).uploadFile(webTarget, SSCFileUpDownloadAPI.FileTokenType.UPLOAD, fprFile);
    }

    @SSCRequiredActionsPermitted(value={"POST=/api/v\\d+/artifacts/\\d+/action"})
    public final JSONMap approveArtifact(String artifactId, String comment) {
        JSONMap data = new JSONMap();
        data.putPath("type", (Object)"approve");
        data.putPath("values.comment", (Object)comment);
        return (JSONMap)this.conn().executeRequest("POST", this.conn().getBaseResource().path("/api/v1/artifacts/").path(artifactId).path("/action"), Entity.entity((Object)data, (String)"application/json"), JSONMap.class);
    }

    public final void approveArtifactAndWaitProcessingCompletion(String artifactId, String comment, int timeOutSeconds) {
        this.approveArtifact(artifactId, comment);
        this.waitForProcessingCompletion(artifactId, timeOutSeconds);
    }

    public final void waitForProcessingCompletion(String artifactId, int timeOutSeconds) {
        HashSet<String> incompleteStates = new HashSet<String>(Arrays.asList("PROCESSING", "SCHED_PROCESSING"));
        long startTime = new Date().getTime();
        JSONMap artifact = this.getArtifactById(artifactId, "status");
        while (new Date().getTime() < startTime + (long)(timeOutSeconds * 1000) && incompleteStates.contains(artifact.get((Object)"status", String.class))) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            artifact = this.getArtifactById(artifactId, "status");
        }
    }

    public final JSONMap getJobForUpload(JSONMap uploadResult, int secondsToWaitForCompletion) {
        String jobId = (String)uploadResult.get((Object)"id", String.class);
        SSCJobAPI jobApi = (SSCJobAPI)this.conn().api(SSCJobAPI.class);
        return jobApi.waitForJobCompletion(jobId, secondsToWaitForCompletion);
    }

    public final String getArtifactIdForUploadJob(JSONMap job) {
        return (String)InternalExpressionHelper.get().evaluateSimpleExpression((Object)job, "jobData.PARAM_ARTIFACT_ID", String.class);
    }

    public final String uploadArtifactAndWaitProcessingCompletion(String applicationVersionId, File fprFile, int timeOutSeconds) {
        JSONMap uploadResult = this.uploadArtifact(applicationVersionId, fprFile);
        JSONMap job = this.getJobForUpload(uploadResult, timeOutSeconds);
        return this.getArtifactIdForUploadJob(job);
    }

    public final String uploadArtifactAndWaitProcessingCompletionWithApproval(String applicationVersionId, File fprFile, String approvalMessage, int timeOutSeconds) {
        long startTimeSeconds = new Date().getTime() / 1000L;
        String artifactId = this.uploadArtifactAndWaitProcessingCompletion(applicationVersionId, fprFile, timeOutSeconds);
        String artifactStatus = (String)this.getArtifactById(artifactId, "status").get((Object)"status", String.class);
        if ("REQUIRE_AUTH".equals(artifactStatus)) {
            int approvalTimeOutSeconds = timeOutSeconds - (int)(new Date().getTime() / 1000L - startTimeSeconds);
            this.approveArtifactAndWaitProcessingCompletion(artifactId, "Auto-approved by Jenkins", approvalTimeOutSeconds);
        }
        return artifactId;
    }
}

