/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.query.builder.SSCAttributeDefinitionsQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONList;
import com.fortify.util.rest.json.JSONMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class SSCAttributeDefinitionAPI
extends AbstractSSCAPI {
    public SSCAttributeDefinitionAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCAttributeDefinitionsQueryBuilder queryAttributeDefinitions() {
        return new SSCAttributeDefinitionsQueryBuilder(this.conn());
    }

    public JSONList getAttributeDefinitions(String ... fields) {
        return this.queryAttributeDefinitions().paramFields(fields).build().getAll();
    }

    public SSCAttributeDefinitionHelper getAttributeDefinitionHelper() {
        return new SSCAttributeDefinitionHelper();
    }

    public SSCCreateAttributeDefinitionBuilder createAttributeDefinition() {
        return new SSCCreateAttributeDefinitionBuilder(this.conn());
    }

    public static final class SSCCreateAttributeDefinitionBuilder {
        private final SSCAuthenticatingRestConnection conn;
        @JsonProperty
        private String name;
        @JsonProperty
        private String description = "";
        @JsonProperty
        private boolean required = false;
        @JsonProperty
        private boolean hidden = false;
        @JsonProperty
        private SSCAttributeDefinitionCategory category = SSCAttributeDefinitionCategory.TECHNICAL;
        @JsonProperty
        private SSCAttributeDefinitionType type = SSCAttributeDefinitionType.TEXT;
        @JsonProperty
        private SSCAttributeDefinitionAppEntityType appEntityType = SSCAttributeDefinitionAppEntityType.PROJECT_VERSION;
        @JsonProperty
        private List<SSCAttributeDefinitionOption> options;

        private SSCCreateAttributeDefinitionBuilder(SSCAuthenticatingRestConnection conn) {
            this.conn = conn;
        }

        public SSCCreateAttributeDefinitionBuilder option(SSCAttributeDefinitionOption option) {
            if (this.options == null) {
                this.options = new ArrayList<SSCAttributeDefinitionOption>();
            }
            this.options.add(option);
            return this;
        }

        @SSCRequiredActionsPermitted(value={"POST=/api/v\\d+/attributeDefinitions"})
        public JSONMap execute() {
            Assert.notNull((Object)this.name, (String)"Attribute definition name must be specified");
            if (!SSCAttributeDefinitionType.SINGLE.equals((Object)this.type) && !SSCAttributeDefinitionType.MULTIPLE.equals((Object)this.type)) {
                Assert.isNull(this.options, (String)"Options are only supported for type SINGLE or MULTIPLE");
            }
            return (JSONMap)this.conn.executeRequest("POST", this.conn.getBaseResource().path("/api/v1/attributeDefinitions"), Entity.entity((Object)this, (String)"application/json"), JSONMap.class);
        }

        @JsonProperty
        public SSCCreateAttributeDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty
        public SSCCreateAttributeDefinitionBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty
        public SSCCreateAttributeDefinitionBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        @JsonProperty
        public SSCCreateAttributeDefinitionBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        @JsonProperty
        public SSCCreateAttributeDefinitionBuilder category(SSCAttributeDefinitionCategory category) {
            this.category = category;
            return this;
        }

        @JsonProperty
        public SSCCreateAttributeDefinitionBuilder type(SSCAttributeDefinitionType type) {
            this.type = type;
            return this;
        }

        @JsonProperty
        public SSCCreateAttributeDefinitionBuilder appEntityType(SSCAttributeDefinitionAppEntityType appEntityType) {
            this.appEntityType = appEntityType;
            return this;
        }

        @JsonProperty
        public SSCCreateAttributeDefinitionBuilder options(List<SSCAttributeDefinitionOption> options) {
            this.options = options;
            return this;
        }

        public static final class SSCAttributeDefinitionOption {
            @JsonProperty
            private final String name;
            @JsonProperty
            private String description;
            @JsonProperty
            private boolean hidden;

            public SSCAttributeDefinitionOption(String name) {
                this.name = name;
            }

            @JsonProperty
            public SSCAttributeDefinitionOption description(String description) {
                this.description = description;
                return this;
            }

            @JsonProperty
            public SSCAttributeDefinitionOption hidden(boolean hidden) {
                this.hidden = hidden;
                return this;
            }
        }
    }

    public final class SSCAttributeDefinitionHelper {
        private JSONList attributeDefinitions;

        private SSCAttributeDefinitionHelper() {
        }

        public JSONList getAttributeDefinitions() {
            if (this.attributeDefinitions == null) {
                this.attributeDefinitions = SSCAttributeDefinitionAPI.this.getAttributeDefinitions(new String[0]);
            }
            return this.attributeDefinitions;
        }

        public String getAttributeIdForName(String attributeName) {
            JSONList attributeDefinitions = this.getAttributeDefinitions();
            return (String)attributeDefinitions.mapValue("name", (Object)attributeName, "id", String.class);
        }

        public String getAttributeNameForId(String attributeId) {
            JSONList attributeDefinitions = this.getAttributeDefinitions();
            return (String)attributeDefinitions.mapValue("id", (Object)attributeId, "name", String.class);
        }

        public JSONMap getAttributeDefinitionsByNameAndId() {
            JSONList attributeDefinitions = this.getAttributeDefinitions();
            JSONMap attributeDefinitionsByNameOrId = attributeDefinitions.toJSONMap("name", String.class, "#this", JSONMap.class);
            attributeDefinitionsByNameOrId.putAll((Map)attributeDefinitions.toMap("id", String.class, JSONMap.class));
            return attributeDefinitionsByNameOrId;
        }

        public MultiValueMap<String, Object> getRequiredAttributesWithDefaultValues() {
            LinkedMultiValueMap result = new LinkedMultiValueMap();
            JSONList attributeDefinitions = this.getAttributeDefinitions();
            for (JSONMap attributeDefinition : attributeDefinitions.asValueType(JSONMap.class)) {
                Object value;
                if ("DYNAMIC_SCAN_REQUEST".equals(attributeDefinition.get((Object)"category")) || !((Boolean)attributeDefinition.get((Object)"required", Boolean.class)).booleanValue() || !Arrays.asList("PROJECT_VERSION", "ALL").contains(attributeDefinition.get((Object)"appEntityType")) || ((Boolean)attributeDefinition.get((Object)"hasDefault", Boolean.class)).booleanValue()) continue;
                String id = (String)attributeDefinition.get((Object)"id", String.class);
                JSONList options = (JSONList)attributeDefinition.get((Object)"options", JSONList.class);
                if (options != null && !options.isEmpty()) {
                    result.add((Object)id, options.mapValue("true", (Object)"true", "guid", String.class));
                    continue;
                }
                switch ((String)attributeDefinition.get((Object)"type", String.class)) {
                    case "INTEGER": {
                        value = 0;
                        break;
                    }
                    case "BOOLEAN": {
                        value = true;
                        break;
                    }
                    case "DATE": {
                        value = new Date();
                        break;
                    }
                    default: {
                        value = "Auto-filled";
                    }
                }
                result.add((Object)id, value);
            }
            return result;
        }
    }

    public static enum SSCAttributeDefinitionAppEntityType {
        PROJECT_VERSION,
        DYNAMIC_SCAN_REQUEST,
        ALL;

    }

    public static enum SSCAttributeDefinitionType {
        TEXT,
        LONG_TEXT,
        SENSITIVE_TEXT,
        SINGLE,
        MULTIPLE,
        BOOLEAN,
        INTEGER,
        DATE,
        FILE;

    }

    public static enum SSCAttributeDefinitionCategory {
        TECHNICAL,
        ORGANIZATION,
        BUSINESS,
        DYNAMIC_SCAN_REQUEST;

    }
}

