/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.query.builder.SSCApplicationVersionBugFilingRequirementsQueryBuilder;
import com.fortify.client.ssc.api.query.builder.SSCApplicationVersionBugTrackerQueryBuilder;
import com.fortify.client.ssc.api.query.builder.SSCBugTrackersQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONList;
import com.fortify.util.rest.json.JSONMap;
import com.fortify.util.spring.expression.helper.InternalExpressionHelper;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.ws.rs.client.Entity;

public class SSCBugTrackerAPI
extends AbstractSSCAPI {
    public SSCBugTrackerAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCApplicationVersionBugTrackerQueryBuilder queryApplicationVersionBugTracker(String applicationVersionId) {
        return new SSCApplicationVersionBugTrackerQueryBuilder(this.conn(), applicationVersionId);
    }

    public SSCApplicationVersionBugFilingRequirementsQueryBuilder queryApplicationVersionBugFilingRequirements(String applicationVersionId) {
        return new SSCApplicationVersionBugFilingRequirementsQueryBuilder(this.conn(), applicationVersionId);
    }

    public SSCBugTrackersQueryBuilder queryBugTrackers() {
        return new SSCBugTrackersQueryBuilder(this.conn());
    }

    public JSONList getBugTrackers(String ... fields) {
        return this.queryBugTrackers().paramFields(fields).build().getAll();
    }

    public Map<String, String> getBugTrackerShortDisplayNamesByIds() {
        return this.getBugTrackers(new String[0]).toMap("pluginId", String.class, "shortDisplayName", String.class);
    }

    public Set<String> getBugTrackerPluginIdsForNames(final Set<String> bugTrackerPluginNames) {
        Map<String, String> namesById = this.getBugTrackerShortDisplayNamesByIds();
        namesById.values().removeIf(new Predicate<String>(){

            @Override
            public boolean test(String name) {
                return !bugTrackerPluginNames.contains(name);
            }
        });
        return namesById.keySet();
    }

    public JSONMap getApplicationVersionBugTracker(String applicationVersionId) {
        return (JSONMap)this.queryApplicationVersionBugTracker(applicationVersionId).build().getUnique().get((Object)"bugTracker", JSONMap.class);
    }

    public String getApplicationVersionBugTrackerShortName(String applicationVersionId) {
        return (String)InternalExpressionHelper.get().evaluateSimpleExpression((Object)this.getApplicationVersionBugTracker(applicationVersionId), "shortDisplayName", String.class);
    }

    @SSCRequiredActionsPermitted(value={"POST=/api/v\\d+/projectVersions/\\d+/bugfilingrequirements/action"})
    public void authenticateForBugFiling(String applicationVersionId, String bugTrackerUserName, String bugTrackerPassword) {
        JSONMap request = new JSONMap();
        request.put((Object)"type", (Object)"login");
        request.put((Object)"ids", (Object)new JSONList());
        request.putPath("values.username", (Object)bugTrackerUserName);
        request.putPath("values.password", (Object)bugTrackerPassword);
        this.conn().executeRequest("POST", this.conn().getBaseResource().path("/api/v1/projectVersions").path(applicationVersionId).path("bugfilingrequirements/action"), Entity.entity((Object)request, (String)"application/json"), JSONMap.class);
    }

    @SSCRequiredActionsPermitted(value={"POST=/api/v\\d+/projectVersions/\\d+/issues/action"})
    public JSONMap fileBug(String applicationVersionId, Map<String, Object> issueDetails, List<String> issueInstanceIds) {
        JSONList bugParams;
        JSONMap bugFilingRequirements = this.getInitialBugFilingRequirements(applicationVersionId);
        HashSet<String> processedDependentParams = new HashSet<String>();
        boolean allDependentParamsProcessed = false;
        block0: while (!allDependentParamsProcessed) {
            bugParams = (JSONList)bugFilingRequirements.get((Object)"bugParams", JSONList.class);
            JSONList bugParamsWithDependenciesAndChoiceList = bugParams.filter("hasDependentParams && choiceList.size()>0", (Object)true);
            LinkedHashMap bugParamsMap = bugParamsWithDependenciesAndChoiceList.toMap("identifier", String.class, JSONMap.class);
            bugParamsMap.keySet().removeAll(processedDependentParams);
            if (bugParamsMap.isEmpty()) {
                allDependentParamsProcessed = true;
                continue;
            }
            for (Map.Entry entry : bugParamsMap.entrySet()) {
                String key = (String)entry.getKey();
                processedDependentParams.add(key);
                String value = (String)issueDetails.get(key);
                if (value == null || value.equals(((JSONMap)entry.getValue()).get((Object)"value"))) continue;
                ((JSONMap)entry.getValue()).put((Object)"value", (Object)value);
                bugFilingRequirements = this.getBugFilingRequirements(applicationVersionId, bugFilingRequirements, key);
                continue block0;
            }
        }
        bugParams = (JSONList)bugFilingRequirements.get((Object)"bugParams", JSONList.class);
        JSONList bugParamsWithoutDependencies = bugParams.filter("hasDependentParams", (Object)false);
        for (JSONMap bugParam : bugParamsWithoutDependencies.asValueType(JSONMap.class)) {
            String key = (String)bugParam.get((Object)"identifier", String.class);
            String value = (String)issueDetails.get(key);
            if (value == null) continue;
            bugParam.put((Object)"value", (Object)value);
        }
        JSONMap request = new JSONMap();
        request.put((Object)"type", (Object)"FILE_BUG");
        request.putPath("values.bugParams", bugFilingRequirements.get((Object)"bugParams", JSONList.class));
        request.putPath("values.issueInstanceIds", issueInstanceIds);
        return (JSONMap)this.conn().executeRequest("POST", this.conn().getBaseResource().path("/api/v1/projectVersions").path(applicationVersionId).path("issues/action"), Entity.entity((Object)request, (String)"application/json"), JSONMap.class);
    }

    public boolean isBugTrackerAuthenticationRequired(String applicationVersionId) {
        JSONMap bugFilingRequirements = this.getInitialBugFilingRequirements(applicationVersionId);
        return (Boolean)InternalExpressionHelper.get().evaluateSimpleExpression((Object)bugFilingRequirements, "requiresAuthentication", Boolean.class);
    }

    private JSONMap getInitialBugFilingRequirements(String applicationVersionId) {
        return this.queryApplicationVersionBugFilingRequirements(applicationVersionId).build().getUnique();
    }

    private JSONMap getBugFilingRequirements(String applicationVersionId, JSONMap data, String changedParamIdentifier) {
        JSONList request = new JSONList();
        request.add((Object)data);
        return this.queryApplicationVersionBugFilingRequirements(applicationVersionId).paramChangedParamIdentifier(changedParamIdentifier).paramBugParams(request).build().getUnique();
    }
}

