/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.annotation.SSCCopyToConstructors;
import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.json.embed.SSCEmbedConfig;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONList;
import com.fortify.util.rest.json.JSONMap;
import com.fortify.util.rest.json.embed.StandardEmbedConfig;
import com.fortify.util.rest.json.embed.StandardEmbedDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang.StringUtils;

public class SSCBulkAPI
extends AbstractSSCAPI {
    public SSCBulkAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCBulkRequestBuilder bulkRequestBuilder() {
        return new SSCBulkRequestBuilder(this.conn());
    }

    public SSCBulkEmbedder bulkEmbedder(SSCEmbedConfig embedConfig) {
        return new SSCBulkEmbedder(this.conn(), embedConfig);
    }

    public static final class SSCBulkEmbedder {
        private Map<String, JSONMap> uriToObjectMap = new HashMap<String, JSONMap>();
        private final SSCAuthenticatingRestConnection conn;
        private final StandardEmbedDefinition embedDefinition;

        public SSCBulkEmbedder(SSCAuthenticatingRestConnection conn, SSCEmbedConfig embedConfig) {
            this.conn = conn;
            this.embedDefinition = new StandardEmbedDefinition((StandardEmbedConfig)embedConfig);
        }

        public Consumer<JSONList> asPagePreProcessor() {
            return jsonList -> this.addBulkData((JSONList)jsonList);
        }

        @SSCCopyToConstructors
        public void addBulkData(JSONList jsonList) {
            SSCBulkRequestBuilder builder = ((SSCBulkAPI)this.conn.api(SSCBulkAPI.class)).bulkRequestBuilder();
            this.addBulkRequests(builder, jsonList);
            try {
                JSONList bulkResults = builder.execute();
                bulkResults.asValueType(JSONMap.class).forEach(this::addResultToInputList);
            }
            catch (RuntimeException e) {
                this.embedDefinition.handleError(e);
            }
        }

        private void addResultToInputList(JSONMap singleBulkResult) {
            String uri = (String)singleBulkResult.getPath("request.uri", String.class);
            JSONMap orgInput = this.uriToObjectMap.get(uri);
            if (orgInput == null) {
                throw new RuntimeException("Unable to find original input object for bulk URI " + uri);
            }
            JSONList responses = (JSONList)singleBulkResult.getPath("responses", JSONList.class);
            if (responses.size() > 1) {
                throw new RuntimeException("Looping not supported");
            }
            if (responses.size() > 0) {
                orgInput.put((Object)this.embedDefinition.getPropertyName(), this.embedDefinition.getResult((JSONMap)((JSONMap)responses.get(0, JSONMap.class)).getPath("body", JSONMap.class)));
            }
        }

        private void addBulkRequests(SSCBulkRequestBuilder builder, JSONList jsonList) {
            jsonList.asValueType(JSONMap.class).forEach(json -> this.addBulkRequest(builder, (JSONMap)json));
        }

        private void addBulkRequest(SSCBulkRequestBuilder builder, JSONMap input) {
            String uri;
            if (this.embedDefinition.isEnabled(input) && StringUtils.isNotBlank((String)(uri = this.embedDefinition.buildUri(input)))) {
                WebTarget target = this.conn.getResource(uri);
                builder.addBulkRequest("GET", target);
                this.uriToObjectMap.put(target.getUri().toString(), input);
            }
        }

        public SSCBulkEmbedder uriToObjectMap(Map<String, JSONMap> uriToObjectMap) {
            this.uriToObjectMap = uriToObjectMap;
            return this;
        }
    }

    public final class SSCBulkRequestBuilder {
        private final SSCAuthenticatingRestConnection conn;
        private final JSONList requests = new JSONList();

        public SSCBulkRequestBuilder(SSCAuthenticatingRestConnection conn) {
            this.conn = conn;
        }

        public SSCBulkRequestBuilder addBulkRequest(String httpMethod, WebTarget webTarget, Object postData) {
            JSONMap request = this.requests.addNewJSONMap();
            request.put((Object)"uri", (Object)webTarget.getUri().toString());
            request.put((Object)"httpVerb", (Object)httpMethod);
            if (postData != null) {
                request.put((Object)"postData", postData);
            }
            return this;
        }

        public SSCBulkRequestBuilder addBulkRequest(String httpMethod, WebTarget webTarget) {
            return this.addBulkRequest(httpMethod, webTarget, null);
        }

        @SSCRequiredActionsPermitted(value={"POST=/api/v\\d+/bulk"})
        public JSONList execute() {
            WebTarget bulkTarget = this.conn.getBaseResource().path("/api/v1/bulk");
            JSONMap bulkRequest = new JSONMap();
            bulkRequest.put((Object)"requests", (Object)this.requests);
            return ((JSONMap)this.conn.executeRequest("POST", bulkTarget, Entity.entity((Object)bulkRequest, (String)"application/json"), JSONMap.class)).getOrCreateJSONList("data");
        }
    }
}

