/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.query.builder.SSCApplicationVersionCustomTagsQueryBuilder;
import com.fortify.client.ssc.api.query.builder.SSCCustomTagsQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONList;
import com.fortify.util.rest.json.JSONMap;
import com.fortify.util.spring.expression.helper.InternalExpressionHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;

public class SSCCustomTagAPI
extends AbstractSSCAPI {
    public SSCCustomTagAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCApplicationVersionCustomTagsQueryBuilder queryApplicationVersionCustomTags(String applicationVersionId) {
        return new SSCApplicationVersionCustomTagsQueryBuilder(this.conn(), applicationVersionId);
    }

    public SSCCustomTagsQueryBuilder queryCustomTags() {
        return new SSCCustomTagsQueryBuilder(this.conn());
    }

    public JSONList getCustomTags() {
        return this.queryCustomTags().build().getAll();
    }

    public SSCCustomTagHelper getCustomTagHelper() {
        return new SSCCustomTagHelper();
    }

    public JSONList getApplicationVersionCustomTags(String applicationVersionId) {
        return this.queryApplicationVersionCustomTags(applicationVersionId).build().getAll();
    }

    public List<String> getApplicationVersionCustomTagNames(String applicationVersionId) {
        return this.getApplicationVersionCustomTags(applicationVersionId).getValues("name", String.class);
    }

    public List<String> getApplicationVersionCustomTagGuids(String applicationVersionId) {
        return this.getApplicationVersionCustomTags(applicationVersionId).getValues("guid", String.class);
    }

    public SSCApplicationVersionCustomTagUpdater updateCustomTags(String applicationVersionId) {
        return new SSCApplicationVersionCustomTagUpdater(applicationVersionId);
    }

    public final class SSCApplicationVersionCustomTagUpdater {
        private final String applicationVersionId;
        private SSCCustomTagHelper customTagHelper;
        private JSONList issues = new JSONList();
        private JSONList customTagAuditValues = new JSONList();

        private SSCApplicationVersionCustomTagUpdater(String applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public SSCApplicationVersionCustomTagUpdater withCustomTagHelper(SSCCustomTagHelper helper) {
            this.customTagHelper = helper;
            return this;
        }

        public SSCApplicationVersionCustomTagUpdater forVulnerability(Object vulnerability) {
            JSONMap issue = new JSONMap();
            Long id = (Long)InternalExpressionHelper.get().evaluateSimpleExpression(vulnerability, "id", Long.class);
            Long revision = (Long)InternalExpressionHelper.get().evaluateSimpleExpression(vulnerability, "revision", Long.class);
            if (revision == null) {
                revision = 0L;
            }
            issue.put((Object)"id", (Object)id);
            issue.put((Object)"revision", (Object)revision);
            this.issues.add((Object)issue);
            return this;
        }

        public SSCApplicationVersionCustomTagUpdater forVulnerabilities(Collection<Object> vulnerabilities) {
            for (Object vuln : vulnerabilities) {
                this.forVulnerability(vuln);
            }
            return this;
        }

        public SSCApplicationVersionCustomTagUpdater byGuid(String customTagGuid, String customTagValue) {
            JSONMap customTagAudit = new JSONMap();
            customTagAudit.put((Object)"customTagGuid", (Object)customTagGuid);
            customTagAudit.put((Object)"textValue", (Object)customTagValue);
            this.customTagAuditValues.add((Object)customTagAudit);
            return this;
        }

        public SSCApplicationVersionCustomTagUpdater byGuid(Map<String, String> customTagGuidToValueMap) {
            for (Map.Entry<String, String> customTagGuidAndValue : customTagGuidToValueMap.entrySet()) {
                this.byGuid(customTagGuidAndValue.getKey(), customTagGuidAndValue.getValue());
            }
            return this;
        }

        public SSCApplicationVersionCustomTagUpdater byName(String customTagName, String customTagValue) {
            return this.byGuid(this.getCustomTagHelper().getCustomTagGuid(customTagName), customTagValue);
        }

        public SSCApplicationVersionCustomTagUpdater byName(Map<String, String> customTagNameToValueMap) {
            for (Map.Entry<String, String> customTagNameAndValue : customTagNameToValueMap.entrySet()) {
                this.byName(customTagNameAndValue.getKey(), customTagNameAndValue.getValue());
            }
            return this;
        }

        @SSCRequiredActionsPermitted(value={"POST=/api/v\\d+/projectVersions/\\d+/issues/action"})
        public void execute() {
            if (this.issues.size() > 0 && this.customTagAuditValues.size() > 0) {
                JSONMap request = new JSONMap();
                request.put((Object)"type", (Object)"AUDIT_ISSUE");
                request.putPath("values.issues", (Object)this.issues);
                request.putPath("values.customTagAudit", (Object)this.customTagAuditValues);
                SSCCustomTagAPI.this.conn().executeRequest("POST", SSCCustomTagAPI.this.conn().getBaseResource().path("/api/v1/projectVersions").path(this.applicationVersionId).path("issues/action"), Entity.entity((Object)request, (String)"application/json"), JSONMap.class);
            }
        }

        private SSCCustomTagHelper getCustomTagHelper() {
            if (this.customTagHelper == null) {
                this.customTagHelper = SSCCustomTagAPI.this.getCustomTagHelper();
            }
            return this.customTagHelper;
        }
    }

    public final class SSCCustomTagHelper {
        private JSONList customTags;

        public JSONList getCustomTags() {
            if (this.customTags == null) {
                this.customTags = SSCCustomTagAPI.this.getCustomTags();
            }
            return this.customTags;
        }

        public String getCustomTagGuid(String customTagName) {
            return (String)this.getCustomTags().mapValue("name.toLowerCase()", (Object)customTagName.toLowerCase(), "guid", String.class);
        }

        public String getCustomTagName(String customTagGUID) {
            return (String)this.getCustomTags().mapValue("guid", (Object)customTagGUID, "name", String.class);
        }
    }
}

