/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONMap;
import com.fortify.util.spring.expression.helper.InternalExpressionHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.Boundary;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SSCFileUpDownloadAPI
extends AbstractSSCAPI {
    public SSCFileUpDownloadAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    @SSCRequiredActionsPermitted(value={"POST=/api/v\\d+/fileTokens"})
    public final String getFileToken(FileTokenType type) {
        JSONMap entity = new JSONMap();
        entity.put((Object)"fileTokenType", (Object)type.toString());
        JSONMap data = (JSONMap)this.conn().executeRequest("POST", this.conn().getBaseResource().path("/api/v1/fileTokens"), Entity.entity((Object)entity, (String)"application/json"), JSONMap.class);
        return (String)InternalExpressionHelper.get().evaluateSimpleExpression((Object)data, "data.token", String.class);
    }

    public final JSONMap uploadFile(WebTarget baseTarget, FileTokenType type, File file) {
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.type(new MediaType("multipart", "form-data", Collections.singletonMap("boundary", Boundary.createBoundary())));
        multiPart.bodyPart((BodyPart)new FormDataBodyPart("Filename", file.getName()));
        multiPart.bodyPart((BodyPart)new FileDataBodyPart(file.getName(), file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        String xml = (String)this.conn().executeRequest("POST", baseTarget.queryParam("mat", new Object[]{this.getFileToken(type)}).request(new String[]{"application/xml"}), Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()), String.class);
        return this.xml2json(new ByteArrayInputStream(xml.getBytes()));
    }

    public final long downloadFile(WebTarget baseTarget, FileTokenType type, Path target) {
        try (Response response = (Response)this.conn().executeRequest("GET", baseTarget.queryParam("mat", new Object[]{this.getFileToken(FileTokenType.DOWNLOAD)}).request(new String[]{"*/*"}), Response.class);){
            long l = Files.copy((InputStream)response.readEntity(InputStream.class), target, StandardCopyOption.REPLACE_EXISTING);
            return l;
        }
    }

    private JSONMap xml2json(InputStream is) {
        try {
            DataCollector handler = new DataCollector();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/validation", true);
            factory.setValidating(true);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return handler.result;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Error converting XML to JSONMap", e);
        }
    }

    private static class DataCollector
    extends DefaultHandler {
        private final StringBuilder buffer = new StringBuilder();
        private final JSONMap result = new JSONMap();

        private DataCollector() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String value = this.buffer.toString().trim();
            if (value.length() > 0) {
                this.result.put((Object)qName.substring(Math.max(0, qName.indexOf(58) + 1)), (Object)value);
            }
            this.buffer.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }
    }

    public static enum FileTokenType {
        UPLOAD,
        DOWNLOAD,
        PREVIEW_FILE,
        REPORT_FILE;

    }
}

