/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.query.builder.SSCApplicationVersionIssuesQueryBuilder;
import com.fortify.client.ssc.api.query.builder.SSCIssueDetailsByIdQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONList;
import com.fortify.util.rest.json.JSONMap;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Entity;

public class SSCIssueAPI
extends AbstractSSCAPI {
    public SSCIssueAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCApplicationVersionIssuesQueryBuilder queryIssues(String applicationVersionId) {
        return new SSCApplicationVersionIssuesQueryBuilder(this.conn(), applicationVersionId);
    }

    public SSCIssueDetailsByIdQueryBuilder queryIssueDetailsById(String issueId) {
        return new SSCIssueDetailsByIdQueryBuilder(this.conn(), issueId);
    }

    public JSONMap getIssueDetails(String issueId, String ... fields) {
        return this.queryIssueDetailsById(issueId).paramFields(fields).build().getUnique();
    }

    @SSCRequiredActionsPermitted(value={"PUT=/api/v\\d+/projectVersions/\\d+/issueSearchOptions"})
    public void updateApplicationVersionIssueSearchOptions(String applicationVersionId, IssueSearchOptions issueSearchOptions) {
        this.conn().executeRequest("PUT", this.conn().getBaseResource().path("/api/v1/projectVersions").path(applicationVersionId).path("issueSearchOptions"), Entity.entity((Object)issueSearchOptions.getJSONRequestData(), (String)"application/json"), JSONMap.class);
    }

    @SSCRequiredActionsPermitted(value={"POST=/api/v\\d+/validateSearchString"})
    public JSONMap validateIssueSearchString(String searchString) {
        JSONMap request = new JSONMap();
        request.put((Object)"stringToValidate", (Object)searchString);
        return (JSONMap)((JSONMap)this.conn().executeRequest("POST", this.conn().getBaseResource().path("/api/v1/validateSearchString"), Entity.entity((Object)request, (String)"application/json"), JSONMap.class)).get((Object)"data", JSONMap.class);
    }

    public static class IssueSearchOptions {
        private Map<String, Boolean> searchOptions = new HashMap<String, Boolean>();

        public boolean isIncludeRemoved() {
            return this.searchOptions.getOrDefault("REMOVED", false);
        }

        public void setIncludeRemoved(boolean includeRemoved) {
            this.searchOptions.put("REMOVED", includeRemoved);
        }

        public boolean isIncludeSuppressed() {
            return this.searchOptions.getOrDefault("SUPPRESSED", false);
        }

        public void setIncludeSuppressed(boolean includeSuppressed) {
            this.searchOptions.put("SUPPRESSED", includeSuppressed);
        }

        public boolean isIncludeHidden() {
            return this.searchOptions.getOrDefault("HIDDEN", false);
        }

        public void setIncludeHidden(boolean includeHidden) {
            this.searchOptions.put("HIDDEN", includeHidden);
        }

        JSONList getJSONRequestData() {
            JSONList result = new JSONList();
            result.add((Object)this.getOption("REMOVED"));
            result.add((Object)this.getOption("SUPPRESSED"));
            result.add((Object)this.getOption("HIDDEN"));
            return result;
        }

        private JSONMap getOption(String optionType) {
            JSONMap result = new JSONMap();
            result.put((Object)"optionType", (Object)optionType);
            result.put((Object)"optionValue", (Object)this.searchOptions.getOrDefault(optionType, false));
            return result;
        }
    }
}

