/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.query.builder.SSCApplicationVersionFilterSetsQueryBuilder;
import com.fortify.client.ssc.api.query.builder.SSCIssueTemplatesQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONList;
import com.fortify.util.rest.json.JSONMap;
import java.text.MessageFormat;

public class SSCIssueTemplateAPI
extends AbstractSSCAPI {
    public SSCIssueTemplateAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCIssueTemplatesQueryBuilder queryIssueTemplates() {
        return new SSCIssueTemplatesQueryBuilder(this.conn());
    }

    public JSONList getIssueTemplates() {
        return this.queryIssueTemplates().build().getAll();
    }

    public SSCApplicationVersionFilterSetsQueryBuilder queryApplicationVersionFilterSets(String applicationVersionId) {
        return new SSCApplicationVersionFilterSetsQueryBuilder(this.conn(), applicationVersionId);
    }

    public JSONList getApplicationVersionFilterSets(String applicationVersionId) {
        return this.queryApplicationVersionFilterSets(applicationVersionId).build().getAll();
    }

    public SSCIssueTemplateHelper getIssueTemplateHelper() {
        return new SSCIssueTemplateHelper();
    }

    public final JSONMap findFilterSetByGuidOrTitle(String applicationVersionId, String filterSetGuidOrTitle) {
        String matchExpr = MessageFormat.format("guid==''{0}'' || title==''{0}''", filterSetGuidOrTitle);
        return (JSONMap)this.getApplicationVersionFilterSets(applicationVersionId).find(matchExpr, (Object)true, JSONMap.class);
    }

    public final JSONMap findDefaultFilterSet(String applicationVersionId) {
        return (JSONMap)this.getApplicationVersionFilterSets(applicationVersionId).find("defaultFilterSet", (Object)true, JSONMap.class);
    }

    public final class SSCIssueTemplateHelper {
        private JSONList issueTemplates;

        private SSCIssueTemplateHelper() {
        }

        public JSONList getIssueTemplates() {
            if (this.issueTemplates == null) {
                this.issueTemplates = SSCIssueTemplateAPI.this.getIssueTemplates();
            }
            return this.issueTemplates;
        }

        public JSONMap getDefaultIssueTemplate() {
            return (JSONMap)this.getIssueTemplates().find("defaultTemplate", (Object)true, JSONMap.class);
        }

        public String getDefaultIssueTemplateId() {
            JSONMap defaultIssueTemplate = this.getDefaultIssueTemplate();
            return defaultIssueTemplate == null ? null : (String)defaultIssueTemplate.get((Object)"id", String.class);
        }

        public String getIssueTemplateIdForName(String issueTemplateName) {
            JSONList issueTemplates = this.getIssueTemplates();
            if (issueTemplates != null) {
                return (String)issueTemplates.mapValue("name", (Object)issueTemplateName, "id", String.class);
            }
            return null;
        }
    }
}

