/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api;

import com.fortify.client.ssc.api.AbstractSSCAPI;
import com.fortify.client.ssc.api.query.builder.SSCJobsQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.applier.ifblank.IfBlank;
import com.fortify.util.rest.json.JSONList;
import com.fortify.util.rest.json.JSONMap;
import com.fortify.util.rest.query.IRestConnectionQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;

public class SSCJobAPI
extends AbstractSSCAPI {
    public SSCJobAPI(SSCAuthenticatingRestConnection conn) {
        super(conn);
    }

    public SSCJobsQueryBuilder queryJobs() {
        return new SSCJobsQueryBuilder(this.conn());
    }

    public final JSONMap getJobById(String jobId, String ... fields) {
        return this.queryJobs().id(IfBlank.ERROR(), jobId).paramFields(fields).build().getUnique();
    }

    public JSONMap waitForJobCompletion(String jobId, int timeOutSeconds) {
        HashSet<String> incompleteStates = new HashSet<String>(Arrays.asList("RUNNING", "PREPARED", "WAITING_FOR_WORKER"));
        long startTime = new Date().getTime();
        JSONMap job = this.getJobById(jobId, "state");
        while (new Date().getTime() < startTime + (long)(timeOutSeconds * 1000) && incompleteStates.contains(job.get((Object)"state", String.class))) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            job = this.getJobById(jobId, "state");
        }
        return job;
    }

    public JSONList waitForJobCreation(IRestConnectionQuery query, long timeOutSeconds) {
        long startTime = new Date().getTime();
        JSONList jobs = query.getAll();
        while (new Date().getTime() < startTime + timeOutSeconds * 1000L && CollectionUtils.isEmpty((Collection)jobs)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            jobs = query.getAll();
        }
        return jobs;
    }
}

