/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api.query.builder;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.SSCAttributeDefinitionAPI;
import com.fortify.client.ssc.api.json.embed.SSCApplicationVersionEmbedConfig;
import com.fortify.client.ssc.api.json.embed.SSCEmbedConfig;
import com.fortify.client.ssc.api.query.builder.AbstractSSCEntityQueryBuilder;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.rest.json.JSONList;
import com.fortify.util.rest.json.JSONMap;
import com.fortify.util.rest.json.preprocessor.IJSONMapPreProcessor;
import com.fortify.util.rest.json.preprocessor.enrich.AbstractJSONMapEnrich;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSSCApplicationVersionsQueryBuilder<T extends AbstractSSCApplicationVersionsQueryBuilder<T>>
extends AbstractSSCEntityQueryBuilder<T> {
    public AbstractSSCApplicationVersionsQueryBuilder(SSCAuthenticatingRestConnection conn) {
        super(conn, true);
    }

    @Override
    protected SSCEmbedConfig.SSCEmbedConfigBuilder<?, ?> createEmbedConfigBuilder() {
        return SSCApplicationVersionEmbedConfig.builder();
    }

    @Override
    public T embed(SSCEmbedConfig embedConfig) {
        if ("attributeValuesByName".equals(embedConfig.getSubEntity())) {
            return this.embedAttributeValuesByName(embedConfig.getPropertyName());
        }
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)super.embed(embedConfig))));
    }

    public T embedAttributeValuesByName(SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper attributeDefinitionHelper) {
        return this.embedAttributeValuesByName("attributeValuesByName", attributeDefinitionHelper);
    }

    public T embedAttributeValuesByName(String propertyName) {
        return this.embedAttributeValuesByName(propertyName, ((SSCAttributeDefinitionAPI)((SSCAuthenticatingRestConnection)this.getConn()).api(SSCAttributeDefinitionAPI.class)).getAttributeDefinitionHelper());
    }

    public T embedAttributeValuesByName(String propertyName, SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper attributeDefinitionHelper) {
        this.embedAttributes(SSCEmbedConfig.EmbedType.PRELOAD, new String[0]);
        this.preProcessor((IJSONMapPreProcessor)new JSONMapEnrichWithAttributeValuesByName(propertyName, attributeDefinitionHelper));
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)this._this()));
    }

    public T embedAttributes(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedAttributes("attributes", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/attributes"})
    public T embedAttributes(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "attributes", embedType, fields))));
    }

    public T embedAuditAssistantTrainingStatus(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedAuditAssistantTrainingStatus("auditAssistantTrainingStatus", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/auditAssistantTrainingStatus"})
    public T embedAuditAssistantTrainingStatus(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "auditAssistantTrainingStatus", embedType, fields))));
    }

    public T embedAuditAssistantStatus(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedAuditAssistantStatus("auditAssistantStatus", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/auditAssistantStatus"})
    public T embedAuditAssistantStatus(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "auditAssistantStatus", embedType, fields))));
    }

    public T embedAuthEntities(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedAuthEntities("authEntities", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/authEntities"})
    public T embedAuthEntities(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "authEntities", embedType, fields))));
    }

    public T embedBugfilingrequirements(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedBugfilingrequirements("bugfilingrequirements", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/bugfilingrequirements"})
    public T embedBugfilingrequirements(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "bugfilingrequirements", embedType, fields))));
    }

    public T embedBugtracker(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedBugtracker("bugtracker", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/bugtracker"})
    public T embedBugtracker(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "bugtracker", embedType, fields))));
    }

    public T embedCustomTags(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedCustomTags("customTags", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/customTags"})
    public T embedCustomTags(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "customTags?limit=-1", embedType, fields))));
    }

    public T embedDynamicScanRequests(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedDynamicScanRequests("dynamicScanRequests", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/dynamicScanRequests"})
    public T embedDynamicScanRequests(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "dynamicScanRequests", embedType, fields))));
    }

    public T embedDynamicScanRequestTemplate(SSCEmbedConfig.EmbedType embedType) {
        return this.embedDynamicScanRequestTemplate("dynamicScanRequestTemplate", embedType);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/dynamicScanRequestTemplate"})
    public T embedDynamicScanRequestTemplate(String propertyName, SSCEmbedConfig.EmbedType embedType) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "dynamicScanRequestTemplate", embedType, new String[0]))));
    }

    public T embedDynamicScanRequestsSummary(SSCEmbedConfig.EmbedType embedType) {
        return this.embedDynamicScanRequestsSummary("dynamicScanRequestsSummary", embedType);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/dynamicScanRequestsSummary"})
    public T embedDynamicScanRequestsSummary(String propertyName, SSCEmbedConfig.EmbedType embedType) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "dynamicScanRequestsSummary", embedType, new String[0]))));
    }

    public T embedFilterSets(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedFilterSets("filterSets", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/filterSets"})
    public T embedFilterSets(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "filterSets?limit=-1", embedType, fields))));
    }

    public T embedFolders(SSCEmbedConfig.EmbedType embedType) {
        return this.embedFolders("folders", embedType);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/folders"})
    public T embedFolders(String propertyName, SSCEmbedConfig.EmbedType embedType) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "folders", embedType, new String[0]))));
    }

    public T embedIidMigrations(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedIidMigrations("iidMigrations", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/iidMigrations"})
    public T embedIidMigrations(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "iidMigrations", embedType, fields))));
    }

    public T embedIssueSearchOptions(SSCEmbedConfig.EmbedType embedType) {
        return this.embedIssueSearchOptions("issueSearchOptions", embedType);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/issueSearchOptions"})
    public T embedIssueSearchOptions(String propertyName, SSCEmbedConfig.EmbedType embedType) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "issueSearchOptions", embedType, new String[0]))));
    }

    public T embedIssueSelectorSet(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedIssueSelectorSet("issueSelectorSet", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/issueSelectorSet"})
    public T embedIssueSelectorSet(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "issueSelectorSet", embedType, fields))));
    }

    public T embedPerformanceIndicatorHistories(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedPerformanceIndicatorHistories("performanceIndicatorHistories", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/performanceIndicatorHistories"})
    public T embedPerformanceIndicatorHistories(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "performanceIndicatorHistories?limit=-1", embedType, fields))));
    }

    public T embedResponsibilities(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedResponsibilities("responsibilities", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/responsibilities"})
    public T embedResponsibilities(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "responsibilities?limit=-1", embedType, new String[0]))));
    }

    public T embedResultProcessingRules(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedResultProcessingRules("resultProcessingRules", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/resultProcessingRules"})
    public T embedResultProcessingRules(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "resultProcessingRules", embedType, fields))));
    }

    public T embedVariableHistories(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedVariableHistories("variableHistories", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/variableHistories"})
    public T embedVariableHistories(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (T)((Object)((AbstractSSCApplicationVersionsQueryBuilder)((Object)this.embedSubEntity(propertyName, "variableHistories?limit=-1", embedType, fields))));
    }

    private final class JSONMapEnrichWithAttributeValuesByName
    extends AbstractJSONMapEnrich {
        private final String propertyName;
        private final SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper attributeDefinitionHelper;

        public JSONMapEnrichWithAttributeValuesByName(String propertyName, SSCAttributeDefinitionAPI.SSCAttributeDefinitionHelper attributeDefinitionHelper) {
            this.propertyName = propertyName;
            this.attributeDefinitionHelper = attributeDefinitionHelper;
        }

        protected void enrich(JSONMap json) {
            json.put((Object)this.propertyName, (Object)this.getAttributeValuesByName((JSONList)json.get((Object)"attributes", JSONList.class)));
        }

        private JSONMap getAttributeValuesByName(JSONList attrs) {
            JSONMap result = new JSONMap();
            for (JSONMap attr : attrs.asValueType(JSONMap.class)) {
                String attrName = this.attributeDefinitionHelper.getAttributeNameForId((String)attr.get((Object)"attributeDefinitionId", String.class));
                JSONList attrValues = (JSONList)attr.get((Object)"values", JSONList.class);
                String attrValue = (String)attr.get((Object)"value", String.class);
                if (StringUtils.isNotBlank((String)attrValue)) {
                    result.put((Object)attrName, (Object)new JSONList(Arrays.asList(attrValue)));
                    continue;
                }
                if (attrValues == null || attrValues.size() <= 0) continue;
                result.put((Object)attrName, (Object)new JSONList((Collection)attrValues.getValues("name", String.class)));
            }
            return result;
        }
    }
}

