/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api.query.builder;

import com.fortify.client.ssc.api.SSCBulkAPI;
import com.fortify.client.ssc.api.json.embed.SSCEmbedConfig;
import com.fortify.client.ssc.api.query.SSCEntityQuery;
import com.fortify.client.ssc.api.query.builder.SSCOrderBy;
import com.fortify.client.ssc.api.query.builder.SSCOrderByDirection;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.applier.ifblank.IfBlank;
import com.fortify.util.applier.ifblank.IfBlankAction;
import com.fortify.util.rest.connection.IRestConnection;
import com.fortify.util.rest.json.embed.StandardEmbedConfig;
import com.fortify.util.rest.query.AbstractRestConnectionQueryBuilder;
import com.fortify.util.rest.query.IRestConnectionQuery;
import com.fortify.util.rest.webtarget.IWebTargetUpdater;
import com.fortify.util.rest.webtarget.IWebTargetUpdaterBuilder;
import com.fortify.util.rest.webtarget.WebTargetQueryParamUpdater;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSSCEntityQueryBuilder<T extends AbstractSSCEntityQueryBuilder<T>>
extends AbstractRestConnectionQueryBuilder<SSCAuthenticatingRestConnection, T> {
    private SSCParamQ paramQ = (SSCParamQ)this.add(new SSCParamQ());

    protected AbstractSSCEntityQueryBuilder(SSCAuthenticatingRestConnection conn, boolean pagingSupported) {
        super((IRestConnection)conn, pagingSupported);
    }

    public IRestConnectionQuery build() {
        return new SSCEntityQuery(this);
    }

    protected T paramEmbed(IfBlankAction ifBlankAction, String entity) {
        return (T)((Object)((AbstractSSCEntityQueryBuilder)this.queryParam(ifBlankAction, "embed", entity)));
    }

    protected T paramEmbed(String entity) {
        return (T)((Object)((AbstractSSCEntityQueryBuilder)this.queryParam(IfBlank.ERROR(), "embed", entity)));
    }

    protected T paramFields(String ... fields) {
        return (T)((Object)((AbstractSSCEntityQueryBuilder)this.queryParam("fields", new String[]{StringUtils.join((Object[])fields, (String)",")})));
    }

    protected T paramOrderBy(IfBlankAction ifBlankAction, SSCOrderBy orderBy) {
        ifBlankAction.apply("orderBy", (Object)orderBy, this::isBlankOrderBy, v -> {
            String orderByParam = v.getField();
            if (SSCOrderByDirection.DESC.equals((Object)v.getDirection())) {
                orderByParam = "-" + orderByParam;
            }
            this.queryParam("orderby", new String[]{orderByParam});
        });
        return (T)((Object)((AbstractSSCEntityQueryBuilder)this._this()));
    }

    private boolean isBlankOrderBy(SSCOrderBy orderBy) {
        return orderBy == null || StringUtils.isBlank((String)orderBy.getField());
    }

    protected T paramGroupBy(IfBlankAction ifBlankAction, String groupBy) {
        return (T)((Object)((AbstractSSCEntityQueryBuilder)this.queryParam(ifBlankAction, "groupby", groupBy)));
    }

    protected T paramQ(IfBlankAction ifBlankAction, String q) {
        return (T)((Object)((AbstractSSCEntityQueryBuilder)this.queryParam(ifBlankAction, "q", q)));
    }

    protected T paramQAnd(IfBlankAction ifBlankAction, String field, Object value) {
        ifBlankAction.apply(field, value, this::isBlankObject, v -> this.paramQ.paramQAnd(field, v));
        return (T)((Object)((AbstractSSCEntityQueryBuilder)this._this()));
    }

    private boolean isBlankObject(Object value) {
        return value == null || value instanceof String && StringUtils.isBlank((String)((String)value));
    }

    public T embed(SSCEmbedConfig embedConfig) {
        SSCEmbedConfig.EmbedType embedType = embedConfig.getEmbedType();
        switch (embedType) {
            case ONDEMAND: {
                return (T)((Object)((AbstractSSCEntityQueryBuilder)super.embed((StandardEmbedConfig)embedConfig)));
            }
            case PRELOAD: {
                return this.embedPreload(embedConfig);
            }
        }
        throw new RuntimeException("Unknown embed type: " + embedType.name());
    }

    public T embedSubEntity(String propertyName, String subEntity, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embed((SSCEmbedConfig)((SSCEmbedConfig.SSCEmbedConfigBuilder)((SSCEmbedConfig.SSCEmbedConfigBuilder)((SSCEmbedConfig.SSCEmbedConfigBuilder)this.createEmbedConfigBuilder().propertyName(propertyName)).subEntity(subEntity)).embedType(embedType).param("fields", fields == null ? null : String.join((CharSequence)",", fields))).build());
    }

    protected SSCEmbedConfig.SSCEmbedConfigBuilder<?, ?> createEmbedConfigBuilder() {
        return SSCEmbedConfig.builder();
    }

    protected T embedPreload(SSCEmbedConfig embedConfig) {
        return (T)((Object)((AbstractSSCEntityQueryBuilder)this.pagePreProcessor(((SSCBulkAPI)((SSCAuthenticatingRestConnection)this.getConn()).api(SSCBulkAPI.class)).bulkEmbedder(embedConfig).asPagePreProcessor())));
    }

    private static class SSCParamQ
    implements IWebTargetUpdaterBuilder {
        private final Map<String, Object> paramQAnds = new HashMap<String, Object>();

        private SSCParamQ() {
        }

        public final SSCParamQ paramQAnd(String field, Object value) {
            this.paramQAnds.put(field, value);
            return this;
        }

        public IWebTargetUpdater build() {
            String q = null;
            if (MapUtils.isNotEmpty(this.paramQAnds)) {
                StringBuffer sb = new StringBuffer();
                for (Map.Entry<String, Object> entry : this.paramQAnds.entrySet()) {
                    String qAppend;
                    Object value = entry.getValue();
                    String string = qAppend = value instanceof String ? entry.getKey() + ":\"" + entry.getValue() + "\"" : entry.getKey() + ":" + entry.getValue();
                    if (sb.length() == 0) {
                        sb.append(qAppend);
                        continue;
                    }
                    sb.append("+and+" + qAppend);
                }
                q = sb.toString();
            }
            return new WebTargetQueryParamUpdater("q", new String[]{q});
        }
    }

    public static interface ISSCEntityQueryBuilderParamQ<T extends AbstractSSCEntityQueryBuilder<T>> {
        public T paramQ(IfBlankAction var1, String var2);

        public T paramQAnd(IfBlankAction var1, String var2, Object var3);
    }

    public static interface ISSCEntityQueryBuilderParamGroupBy<T extends AbstractSSCEntityQueryBuilder<T>> {
        public T paramGroupBy(IfBlankAction var1, String var2);
    }

    public static interface ISSCEntityQueryBuilderParamOrderBy<T extends AbstractSSCEntityQueryBuilder<T>> {
        public T paramOrderBy(IfBlankAction var1, SSCOrderBy var2);
    }

    public static interface ISSCEntityQueryBuilderParamFields<T extends AbstractSSCEntityQueryBuilder<T>> {
        public T paramFields(String ... var1);
    }

    public static interface ISSCEntityQueryBuilderParamEmbed<T extends AbstractSSCEntityQueryBuilder<T>> {
        public T paramEmbed(IfBlankAction var1, String var2);
    }
}

