/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api.query.builder;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.json.embed.SSCApplicationVersionIssuesEmbedConfig;
import com.fortify.client.ssc.api.json.embed.SSCEmbedConfig;
import com.fortify.client.ssc.api.query.builder.AbstractSSCApplicationVersionChildEntityQueryBuilder;
import com.fortify.client.ssc.api.query.builder.AbstractSSCEntityQueryBuilder;
import com.fortify.client.ssc.api.query.builder.SSCOrderBy;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.applier.ifblank.IfBlankAction;
import com.fortify.util.rest.json.preprocessor.IJSONMapPreProcessor;
import com.fortify.util.rest.json.preprocessor.enrich.JSONMapEnrichWithDeepLink;
import com.fortify.util.rest.query.IRestConnectionQuery;
import org.apache.commons.lang.StringUtils;

public class SSCApplicationVersionIssuesQueryBuilder
extends AbstractSSCApplicationVersionChildEntityQueryBuilder<SSCApplicationVersionIssuesQueryBuilder>
implements AbstractSSCEntityQueryBuilder.ISSCEntityQueryBuilderParamFields<SSCApplicationVersionIssuesQueryBuilder>,
AbstractSSCEntityQueryBuilder.ISSCEntityQueryBuilderParamOrderBy<SSCApplicationVersionIssuesQueryBuilder>,
AbstractSSCEntityQueryBuilder.ISSCEntityQueryBuilderParamQ<SSCApplicationVersionIssuesQueryBuilder> {
    private static final String[] DEEPLINK_FIELDS = new String[]{"projectVersionId", "id", "engineType", "issueInstanceId"};
    private String filterSetId = null;

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions/\\d+/issues"})
    public SSCApplicationVersionIssuesQueryBuilder(SSCAuthenticatingRestConnection conn, String applicationVersionId) {
        super(conn, applicationVersionId, true);
        this.appendPath("issues");
    }

    @Override
    public IRestConnectionQuery build() {
        String deepLinkExpression = ((SSCAuthenticatingRestConnection)this.getConn()).getBaseUrlStringWithoutTrailingSlash() + "/html/ssc/version/${projectVersionId}/fix/${id}/?engineType=${engineType}&issue=${issueInstanceId}";
        if (StringUtils.isNotBlank((String)this.filterSetId)) {
            deepLinkExpression = deepLinkExpression + "&filterSet=" + this.filterSetId;
        }
        this.preProcessor((IJSONMapPreProcessor)new JSONMapEnrichWithDeepLink(deepLinkExpression, DEEPLINK_FIELDS));
        return super.build();
    }

    @Override
    protected SSCEmbedConfig.SSCEmbedConfigBuilder<?, ?> createEmbedConfigBuilder() {
        return SSCApplicationVersionIssuesEmbedConfig.builder();
    }

    @Override
    public final SSCApplicationVersionIssuesQueryBuilder paramFields(String ... fields) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.paramFields(fields);
    }

    @Override
    public final SSCApplicationVersionIssuesQueryBuilder paramOrderBy(IfBlankAction ifBlankAction, SSCOrderBy orderBy) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.paramOrderBy(ifBlankAction, orderBy);
    }

    @Override
    public final SSCApplicationVersionIssuesQueryBuilder paramQ(IfBlankAction ifBlankAction, String q) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.paramQ(ifBlankAction, q);
    }

    @Override
    public final SSCApplicationVersionIssuesQueryBuilder paramQAnd(IfBlankAction ifBlankAction, String field, Object value) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.paramQAnd(ifBlankAction, field, value);
    }

    public final SSCApplicationVersionIssuesQueryBuilder paramGroupId(IfBlankAction ifBlankAction, String groupId) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.queryParam(ifBlankAction, "groupid", groupId);
    }

    public final SSCApplicationVersionIssuesQueryBuilder paramGroupingType(IfBlankAction ifBlankAction, String groupingType) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.queryParam(ifBlankAction, "groupingtype", groupingType);
    }

    public final SSCApplicationVersionIssuesQueryBuilder paramFilterSetId(IfBlankAction ifBlankAction, String filterSetId) {
        this.filterSetId = filterSetId;
        return (SSCApplicationVersionIssuesQueryBuilder)super.queryParam(ifBlankAction, "filterset", filterSetId);
    }

    public final SSCApplicationVersionIssuesQueryBuilder paramFilter(IfBlankAction ifBlankAction, String filter) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.queryParam(ifBlankAction, "filter", filter);
    }

    public final SSCApplicationVersionIssuesQueryBuilder paramQm(IfBlankAction ifBlankAction, QueryMode queryMode) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.queryParam(ifBlankAction, "qm", queryMode.name());
    }

    public SSCApplicationVersionIssuesQueryBuilder paramShowHidden(boolean showHidden) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.queryParam("showhidden", new String[]{"" + showHidden});
    }

    public SSCApplicationVersionIssuesQueryBuilder paramShowRemoved(boolean showRemoved) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.queryParam("showremoved", new String[]{"" + showRemoved});
    }

    public SSCApplicationVersionIssuesQueryBuilder paramShowSuppressed(boolean showSuppressed) {
        return (SSCApplicationVersionIssuesQueryBuilder)super.queryParam("showsuppressed", new String[]{"" + showSuppressed});
    }

    public SSCApplicationVersionIssuesQueryBuilder embedSubEntity(String entityName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (SSCApplicationVersionIssuesQueryBuilder)this.embedSubEntity(entityName, entityName, embedType, fields);
    }

    public SSCApplicationVersionIssuesQueryBuilder embedAuditHistory(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedAuditHistory("auditHistory", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/issues/\\d+/auditHistory"})
    public SSCApplicationVersionIssuesQueryBuilder embedAuditHistory(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (SSCApplicationVersionIssuesQueryBuilder)this.embedSubEntity(propertyName, "auditHistory", embedType, new String[0]);
    }

    public SSCApplicationVersionIssuesQueryBuilder embedComments(SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return this.embedComments("comments", embedType, fields);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/issues/\\d+/comments"})
    public SSCApplicationVersionIssuesQueryBuilder embedComments(String propertyName, SSCEmbedConfig.EmbedType embedType, String ... fields) {
        return (SSCApplicationVersionIssuesQueryBuilder)this.embedSubEntity(propertyName, "comments", embedType, new String[0]);
    }

    public SSCApplicationVersionIssuesQueryBuilder embedDetails(SSCEmbedConfig.EmbedType embedType) {
        return this.embedDetails("details", embedType);
    }

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/issuesDetails/\\d+"})
    public SSCApplicationVersionIssuesQueryBuilder embedDetails(String propertyName, SSCEmbedConfig.EmbedType embedType) {
        return (SSCApplicationVersionIssuesQueryBuilder)this.embedSubEntity(propertyName, "details", embedType, new String[0]);
    }

    public static enum QueryMode {
        adv,
        issues;

    }
}

