/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.api.query.builder;

import com.fortify.client.ssc.annotation.SSCRequiredActionsPermitted;
import com.fortify.client.ssc.api.query.builder.AbstractSSCApplicationVersionsQueryBuilder;
import com.fortify.client.ssc.api.query.builder.AbstractSSCEntityQueryBuilder;
import com.fortify.client.ssc.api.query.builder.SSCOrderBy;
import com.fortify.client.ssc.connection.SSCAuthenticatingRestConnection;
import com.fortify.util.applier.ifblank.IfBlank;
import com.fortify.util.applier.ifblank.IfBlankAction;
import com.fortify.util.rest.json.preprocessor.IJSONMapPreProcessor;
import com.fortify.util.rest.json.preprocessor.enrich.JSONMapEnrichWithDeepLink;
import org.apache.commons.lang.StringUtils;

public final class SSCApplicationVersionsQueryBuilder
extends AbstractSSCApplicationVersionsQueryBuilder<SSCApplicationVersionsQueryBuilder>
implements AbstractSSCEntityQueryBuilder.ISSCEntityQueryBuilderParamFields<SSCApplicationVersionsQueryBuilder>,
AbstractSSCEntityQueryBuilder.ISSCEntityQueryBuilderParamOrderBy<SSCApplicationVersionsQueryBuilder>,
AbstractSSCEntityQueryBuilder.ISSCEntityQueryBuilderParamQ<SSCApplicationVersionsQueryBuilder> {
    private static final String[] DEEPLINK_FIELDS = new String[]{"id"};

    @SSCRequiredActionsPermitted(value={"GET=/api/v\\d+/projectVersions"})
    public SSCApplicationVersionsQueryBuilder(SSCAuthenticatingRestConnection conn) {
        super(conn);
        this.appendPath("/api/v1/projectVersions");
        this.preProcessor((IJSONMapPreProcessor)new JSONMapEnrichWithDeepLink(conn.getBaseUrlStringWithoutTrailingSlash() + "/html/ssc/index.jsp#!/version/${id}/fix", DEEPLINK_FIELDS));
    }

    @Override
    public final SSCApplicationVersionsQueryBuilder paramFields(String ... fields) {
        return (SSCApplicationVersionsQueryBuilder)super.paramFields(fields);
    }

    @Override
    public final SSCApplicationVersionsQueryBuilder paramOrderBy(IfBlankAction ifBlankAction, SSCOrderBy orderBy) {
        return (SSCApplicationVersionsQueryBuilder)super.paramOrderBy(ifBlankAction, orderBy);
    }

    @Override
    public final SSCApplicationVersionsQueryBuilder paramQ(IfBlankAction ifBlankAction, String q) {
        return (SSCApplicationVersionsQueryBuilder)super.paramQ(ifBlankAction, q);
    }

    @Override
    public final SSCApplicationVersionsQueryBuilder paramQAnd(IfBlankAction ifBlankAction, String field, Object value) {
        return (SSCApplicationVersionsQueryBuilder)super.paramQAnd(ifBlankAction, field, value);
    }

    public SSCApplicationVersionsQueryBuilder id(IfBlankAction ifBlankAction, String id) {
        return (SSCApplicationVersionsQueryBuilder)super.paramQAnd(ifBlankAction, "id", id);
    }

    public SSCApplicationVersionsQueryBuilder applicationId(IfBlankAction ifBlankAction, String applicationId) {
        return (SSCApplicationVersionsQueryBuilder)super.paramQAnd(ifBlankAction, "project.id", applicationId);
    }

    public SSCApplicationVersionsQueryBuilder applicationName(IfBlankAction ifBlankAction, String applicationName) {
        return (SSCApplicationVersionsQueryBuilder)super.paramQAnd(ifBlankAction, "project.name", applicationName);
    }

    public SSCApplicationVersionsQueryBuilder versionName(IfBlankAction ifBlankAction, String versionName) {
        return (SSCApplicationVersionsQueryBuilder)super.paramQAnd(ifBlankAction, "name", versionName);
    }

    public SSCApplicationVersionsQueryBuilder applicationAndOrVersionName(IfBlankAction ifBlankAction, String applicationAndOrVersionName) {
        return this.applicationAndOrVersionName(ifBlankAction, applicationAndOrVersionName, ":");
    }

    public SSCApplicationVersionsQueryBuilder applicationAndOrVersionName(IfBlankAction ifBlankAction, String applicationAndOrVersionName, String separator) {
        ifBlankAction.apply("Application and/or version name", (Object)applicationAndOrVersionName, StringUtils::isBlank, v -> {
            String[] elts = v.split(separator);
            if (elts.length == 1 && StringUtils.isNotBlank((String)elts[0]) || elts.length == 2 && StringUtils.isBlank((String)elts[1])) {
                this.applicationName(IfBlank.ERROR(), elts[0]);
            } else if (elts.length == 2 && StringUtils.isBlank((String)elts[0])) {
                this.versionName(IfBlank.ERROR(), elts[1]);
            } else if (elts.length == 2) {
                this.applicationName(IfBlank.ERROR(), elts[0]).versionName(IfBlank.ERROR(), elts[1]);
            } else {
                throw new IllegalArgumentException("Applications or versions containing a '" + separator + "' are unsupported");
            }
        });
        return (SSCApplicationVersionsQueryBuilder)this._this();
    }

    public SSCApplicationVersionsQueryBuilder nameOrId(IfBlankAction ifBlankAction, String applicationVersionNameOrId, String separator) {
        ifBlankAction.apply("Version name or id", (Object)applicationVersionNameOrId, StringUtils::isBlank, v -> {
            String[] appVersionElements = v.split(separator);
            if (appVersionElements.length == 1) {
                this.id(IfBlank.ERROR(), appVersionElements[0]);
            } else if (appVersionElements.length == 2) {
                this.applicationName(IfBlank.ERROR(), appVersionElements[0]).versionName(IfBlank.ERROR(), appVersionElements[1]);
            } else {
                throw new IllegalArgumentException("Applications or versions containing a '+separator+' can only be specified by id");
            }
        });
        return (SSCApplicationVersionsQueryBuilder)this._this();
    }

    public SSCApplicationVersionsQueryBuilder nameOrId(IfBlankAction ifBlankAction, String applicationVersionNameOrId) {
        return this.nameOrId(ifBlankAction, applicationVersionNameOrId, ":");
    }
}

