/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.connection;

import com.fortify.client.ssc.connection.ISSCTokenFactory;
import com.fortify.client.ssc.connection.SSCBasicRestConnection;
import com.fortify.client.ssc.connection.SSCRestConnectionConfig;
import com.fortify.client.ssc.connection.SSCTokenFactoryTokenCredentials;
import com.fortify.client.ssc.connection.SSCTokenFactoryUserCredentials;
import com.fortify.util.rest.connection.AbstractRestConnectionConfig;
import com.fortify.util.rest.connection.IRestConnectionBuilder;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang.StringUtils;

public class SSCAuthenticatingRestConnection
extends SSCBasicRestConnection {
    private final ISSCTokenFactory tokenFactory;

    public SSCAuthenticatingRestConnection(SSCRestConnectionConfig<?> config) {
        super((AbstractRestConnectionConfig<?>)config);
        this.tokenFactory = this.getTokenFactory(config);
    }

    private ISSCTokenFactory getTokenFactory(SSCRestConnectionConfig<?> config) {
        if (StringUtils.isNotBlank((String)config.getAuthToken())) {
            return new SSCTokenFactoryTokenCredentials(config.getAuthToken());
        }
        if (StringUtils.isNotBlank((String)config.getUserName()) && StringUtils.isNotBlank((String)config.getPassword())) {
            return new SSCTokenFactoryUserCredentials((AbstractRestConnectionConfig<?>)config, config.getUserName(), config.getPassword(), config.getTokenDescription());
        }
        throw new RuntimeException("Either SSC authentication token, or user name and password need to be specified");
    }

    public void close() {
        super.close();
        this.tokenFactory.close();
    }

    @Override
    public Invocation.Builder updateBuilder(Invocation.Builder builder) {
        String token = this.isMultiThreaded() ? this.tokenFactory.getTokenSynchronized() : this.tokenFactory.getToken();
        return super.updateBuilder(builder).header("Authorization", (Object)("FortifyToken " + token));
    }

    public static final SSCAuthenticatingRestConnectionBuilder builder() {
        return new SSCAuthenticatingRestConnectionBuilder();
    }

    public static class SSCAuthenticatingRestConnectionBuilder
    extends SSCRestConnectionConfig<SSCAuthenticatingRestConnectionBuilder>
    implements IRestConnectionBuilder<SSCAuthenticatingRestConnection> {
        public SSCAuthenticatingRestConnection build() {
            return new SSCAuthenticatingRestConnection(this);
        }
    }
}

