/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.client.ssc.connection;

import com.fortify.client.ssc.connection.ISSCTokenFactory;
import com.fortify.client.ssc.connection.SSCBasicRestConnection;
import com.fortify.util.log4j.LogMaskingHelper;
import com.fortify.util.rest.connection.AbstractRestConnectionConfig;
import com.fortify.util.rest.json.JSONMap;
import java.util.Date;
import java.util.regex.Pattern;
import javax.ws.rs.client.Entity;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SSCTokenFactoryUserCredentials
implements ISSCTokenFactory {
    private static final Log log = LogFactory.getLog(SSCTokenFactoryUserCredentials.class);
    private final Pattern EXPR_TOKEN = Pattern.compile("\"token\":\"([^\"]+)\"");
    private final SSCBasicRestConnection conn;
    private final String userName;
    private final String password;
    private final String tokenDescription;
    private TokenData tokenData = null;

    public SSCTokenFactoryUserCredentials(AbstractRestConnectionConfig<?> config, String userName, String password, String tokenDescription) {
        this.conn = new SSCBasicRestConnection(config);
        this.userName = userName;
        this.password = password;
        this.tokenDescription = tokenDescription;
    }

    @Override
    public synchronized String getTokenSynchronized() {
        return this.getToken();
    }

    @Override
    public void close() {
        this.revokeToken();
        this.conn.close();
    }

    private void revokeToken() {
        if (this.tokenData != null) {
            JSONMap postData = new JSONMap();
            postData.putPath("tokens", (Object)new String[]{this.tokenData.getToken()});
            this.tokenData = null;
            try {
                this.performTokenRequest("/api/v1/tokens/action/revoke", postData);
                log.debug((Object)"[SSC] Revoked access token");
            }
            catch (RuntimeException e) {
                log.warn((Object)"[SSC] Error revoking access token");
                log.debug((Object)"Token revocation exception details", (Throwable)e);
            }
        }
    }

    @Override
    public String getToken() {
        if (this.tokenData == null || this.tokenData.isExpired()) {
            JSONMap postData = new JSONMap();
            postData.putPath("type", (Object)"UnifiedLoginToken");
            postData.putPath("description", (Object)this.tokenDescription);
            this.tokenData = this.getTokenData(this.performTokenRequest("/api/v1/tokens", postData));
            log.info((Object)("[SSC] Obtained access token, expiring at " + this.tokenData.getTerminalDate().toString()));
        }
        return this.tokenData.getToken();
    }

    private TokenData getTokenData(JSONMap json) {
        JSONMap data = (JSONMap)json.get((Object)"data", JSONMap.class);
        return new TokenData((String)data.get((Object)"token"), (Date)data.get((Object)"terminalDate", Date.class));
    }

    private JSONMap performTokenRequest(String endpoint, JSONMap postData) {
        String authHeaderValue = "Basic " + Base64.encodeBase64String((byte[])(this.userName + ":" + this.password).getBytes());
        return (JSONMap)LogMaskingHelper.maskByPatternGroups().patterns(new Pattern[]{this.EXPR_TOKEN}).on(() -> (JSONMap)this.conn.executeRequest("POST", this.conn.getBaseResource().path(endpoint).request().header("Authorization", (Object)authHeaderValue), Entity.entity((Object)postData, (String)"application/json"), JSONMap.class));
    }

    private static final class TokenData {
        private final String token;
        private final Date terminalDate;

        public boolean isExpired() {
            return new Date().getTime() > this.getTerminalDate().getTime();
        }

        public TokenData(String token, Date terminalDate) {
            this.token = token;
            this.terminalDate = terminalDate;
        }

        public String getToken() {
            return this.token;
        }

        public Date getTerminalDate() {
            return this.terminalDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenData)) {
                return false;
            }
            TokenData other = (TokenData)o;
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            Date this$terminalDate = this.getTerminalDate();
            Date other$terminalDate = other.getTerminalDate();
            return !(this$terminalDate == null ? other$terminalDate != null : !((Object)this$terminalDate).equals(other$terminalDate));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            Date $terminalDate = this.getTerminalDate();
            result = result * 59 + ($terminalDate == null ? 43 : ((Object)$terminalDate).hashCode());
            return result;
        }

        public String toString() {
            return "SSCTokenFactoryUserCredentials.TokenData(token=" + this.getToken() + ", terminalDate=" + this.getTerminalDate() + ")";
        }
    }
}

