/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;

public class DialectSensitiveNamingStrategy
extends EJB3NamingStrategy {
    public static final NamingStrategy INSTANCE = new DialectSensitiveNamingStrategy();

    public String classToTableName(String className) {
        return DialectSensitiveNamingStrategy.keywordCheck(StringHelper.unqualify((String)className));
    }

    public String propertyToColumnName(String propertyName) {
        return DialectSensitiveNamingStrategy.keywordCheck(StringHelper.unqualify((String)propertyName));
    }

    public String tableName(String tableName) {
        return DialectSensitiveNamingStrategy.keywordCheck(tableName);
    }

    public String columnName(String columnName) {
        return DialectSensitiveNamingStrategy.keywordCheck(columnName);
    }

    public String logicalColumnName(String columnName, String propertyName) {
        return StringHelper.isNotEmpty((String)columnName) ? columnName : StringHelper.unqualify((String)propertyName);
    }

    protected static String keywordCheck(String name) {
        name = name.replace('$', '_');
        if (Dialect.getDialect().getKeywords().contains(name.toLowerCase())) {
            Dialect d = Dialect.getDialect();
            name = d.openQuote() + name + d.closeQuote();
        }
        return name;
    }
}

