/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class FoundationDBSQLDialect
extends Dialect {
    private static final ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sqle) {
            try {
                int sqlState = Integer.valueOf(JdbcExceptionHelper.extractSqlState((SQLException)sqle));
                switch (sqlState) {
                    case 23501: {
                        return this.extractUsingTemplate("violates unique constraint ", "\"", sqle.getMessage());
                    }
                    case 23503: {
                        return this.extractUsingTemplate("due to foreign key constraint ", " on ", sqle.getMessage());
                    }
                    case 23502: {
                        return this.extractUsingTemplate("NULL value not permitted for ", "\"", sqle.getMessage());
                    }
                }
                return null;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    };

    public FoundationDBSQLDialect() {
        this.registerColumnType(-3, "varchar($l) for bit data");
        this.registerColumnType(-4, "varchar($l) for bit data");
        this.registerColumnType(-2, 1024L, "char($l) for bit data");
        this.registerColumnType(-2, "char(1024) for bit data");
        this.registerColumnType(2, "decimal($p,$s)");
        this.registerColumnType(-1, "clob");
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("bin", (SQLFunction)new StandardSQLFunction("bin", (Type)StandardBasicTypes.STRING));
        this.registerFunction("char_length", (SQLFunction)new StandardSQLFunction("char_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("character_length", (SQLFunction)new StandardSQLFunction("character_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase"));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim"));
        this.registerFunction("ord", (SQLFunction)new StandardSQLFunction("ord", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("quote", (SQLFunction)new StandardSQLFunction("quote"));
        this.registerFunction("reverse", (SQLFunction)new StandardSQLFunction("reverse"));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim"));
        this.registerFunction("soundex", (SQLFunction)new StandardSQLFunction("soundex"));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction("space", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase"));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("unhex", (SQLFunction)new StandardSQLFunction("unhex", (Type)StandardBasicTypes.STRING));
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("crc32", (SQLFunction)new StandardSQLFunction("crc32", (Type)StandardBasicTypes.LONG));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ln", (SQLFunction)new StandardSQLFunction("ln", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log2", (SQLFunction)new StandardSQLFunction("log2", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction("log10", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("pi", (SQLFunction)new NoArgSQLFunction("pi", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("rand", (SQLFunction)new NoArgSQLFunction("rand", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("stddev", (SQLFunction)new StandardSQLFunction("std", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction("ceiling", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceil", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("datediff", (SQLFunction)new StandardSQLFunction("datediff", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("timediff", (SQLFunction)new StandardSQLFunction("timediff", (Type)StandardBasicTypes.TIME));
        this.registerFunction("date_format", (SQLFunction)new StandardSQLFunction("date_format", (Type)StandardBasicTypes.STRING));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)StandardBasicTypes.DATE));
        this.registerFunction("curtime", (SQLFunction)new NoArgSQLFunction("curtime", (Type)StandardBasicTypes.TIME));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("current_date", (Type)StandardBasicTypes.DATE, false));
        this.registerFunction("current_time", (SQLFunction)new NoArgSQLFunction("current_time", (Type)StandardBasicTypes.TIME, false));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current_timestamp", (Type)StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("date", (SQLFunction)new StandardSQLFunction("date", (Type)StandardBasicTypes.DATE));
        this.registerFunction("day", (SQLFunction)new StandardSQLFunction("day", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)StandardBasicTypes.STRING));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("from_days", (SQLFunction)new StandardSQLFunction("from_days", (Type)StandardBasicTypes.DATE));
        this.registerFunction("from_unixtime", (SQLFunction)new StandardSQLFunction("from_unixtime", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction("hour", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("last_day", (SQLFunction)new StandardSQLFunction("last_day", (Type)StandardBasicTypes.DATE));
        this.registerFunction("localtime", (SQLFunction)new NoArgSQLFunction("localtime", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("localtimestamp", (SQLFunction)new NoArgSQLFunction("localtimestamp", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("microseconds", (SQLFunction)new StandardSQLFunction("microseconds", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction("minute", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)StandardBasicTypes.STRING));
        this.registerFunction("now", (SQLFunction)new NoArgSQLFunction("now", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("quarter", (SQLFunction)new StandardSQLFunction("quarter", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction("second", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("sec_to_time", (SQLFunction)new StandardSQLFunction("sec_to_time", (Type)StandardBasicTypes.TIME));
        this.registerFunction("sysdate", (SQLFunction)new NoArgSQLFunction("sysdate", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("time", (SQLFunction)new StandardSQLFunction("time", (Type)StandardBasicTypes.TIME));
        this.registerFunction("timestamp", (SQLFunction)new StandardSQLFunction("timestamp", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("time_to_sec", (SQLFunction)new StandardSQLFunction("time_to_sec", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("to_days", (SQLFunction)new StandardSQLFunction("to_days", (Type)StandardBasicTypes.LONG));
        this.registerFunction("unix_timestamp", (SQLFunction)new StandardSQLFunction("unix_timestamp", (Type)StandardBasicTypes.LONG));
        this.registerFunction("utc_date", (SQLFunction)new NoArgSQLFunction("utc_date", (Type)StandardBasicTypes.STRING));
        this.registerFunction("utc_time", (SQLFunction)new NoArgSQLFunction("utc_time", (Type)StandardBasicTypes.STRING));
        this.registerFunction("utc_timestamp", (SQLFunction)new NoArgSQLFunction("utc_timestamp", (Type)StandardBasicTypes.STRING));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("weekday", (SQLFunction)new StandardSQLFunction("weekday", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("weekofyear", (SQLFunction)new StandardSQLFunction("weekofyear", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("yearweek", (SQLFunction)new StandardSQLFunction("yearweek", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("hex", (SQLFunction)new StandardSQLFunction("hex", (Type)StandardBasicTypes.STRING));
        this.registerFunction("oct", (SQLFunction)new StandardSQLFunction("oct", (Type)StandardBasicTypes.STRING));
        this.registerFunction("octet_length", (SQLFunction)new StandardSQLFunction("octet_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("bit_length", (SQLFunction)new StandardSQLFunction("bit_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("bit_count", (SQLFunction)new StandardSQLFunction("bit_count", (Type)StandardBasicTypes.LONG));
        this.registerFunction("encrypt", (SQLFunction)new StandardSQLFunction("encrypt", (Type)StandardBasicTypes.STRING));
        this.registerFunction("md5", (SQLFunction)new StandardSQLFunction("md5", (Type)StandardBasicTypes.STRING));
        this.registerFunction("sha1", (SQLFunction)new StandardSQLFunction("sha1", (Type)StandardBasicTypes.STRING));
        this.registerFunction("sha", (SQLFunction)new StandardSQLFunction("sha", (Type)StandardBasicTypes.STRING));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "", "||", ""));
        this.registerFunction("str", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "cast(?1 as varchar(8192))"));
        this.registerKeyword("year");
        this.registerKeyword("user");
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentityColumnString(int type) {
        return "serial not null";
    }

    public boolean hasDataTypeInIdentityColumn() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName);
    }

    public String getSelectSequenceNextValString(String sequenceName) {
        return "NEXT VALUE FOR " + sequenceName;
    }

    protected String getCreateSequenceString(String sequenceName) throws MappingException {
        return this.getCreateSequenceString(sequenceName, 1, 1);
    }

    protected String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        return "create sequence " + sequenceName + " start with " + initialValue + " increment by " + incrementSize;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    public String getQuerySequencesString() {
        return "select sequence_name from information_schema.sequences";
    }

    public Class getNativeIdentifierGeneratorClass() {
        return IdentityGenerator.class;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return sql + (hasOffset ? " limit ? offset ?" : " limit ?");
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public String getNoColumnsInsertString() {
        return "values (DEFAULT)";
    }

    public int getMaxAliasLength() {
        return 100;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsTemporaryTables() {
        return false;
    }

    public Boolean performTemporaryTableDDLInIsolation() {
        return null;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public boolean supportsTuplesInSubqueries() {
        return false;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    public boolean supportsTableCheck() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }
}

