/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime;

import com.foursoft.harness.navext.runtime.IdLookupProvider;
import com.foursoft.harness.navext.runtime.JaxbContextFactory;
import com.foursoft.harness.navext.runtime.JaxbModel;
import com.foursoft.harness.navext.runtime.postprocessing.IdLookupGeneratorPostProcessor;
import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessor;
import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessorManager;
import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessorRegistry;
import com.foursoft.harness.navext.runtime.postprocessing.ReflectiveAssociationPostProcessor;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExtendedUnmarshaller<R, I> {
    private final ModelPostProcessorRegistry postProcessorRegistry;
    private final List<IdLookupGeneratorPostProcessor<I>> idLookupGenerators = new ArrayList<IdLookupGeneratorPostProcessor<I>>();
    private final Unmarshaller unmarshaller;
    private final Class<R> rootElement;
    private XMLReader reader = null;

    public ExtendedUnmarshaller(Class<R> rootElement) throws JAXBException {
        this.rootElement = rootElement;
        String packageName = rootElement.getPackage().getName();
        JAXBContext context = JaxbContextFactory.initializeContext(packageName, this.getClass().getClassLoader());
        this.postProcessorRegistry = new ModelPostProcessorRegistry(packageName);
        this.unmarshaller = context.createUnmarshaller();
    }

    public ExtendedUnmarshaller<R, I> withBackReferences() {
        this.postProcessorRegistry.withFactory(ReflectiveAssociationPostProcessor::new);
        return this;
    }

    public ExtendedUnmarshaller<R, I> withCustomPostProcessor(ModelPostProcessor modelPostProcessor) {
        this.postProcessorRegistry.addDefaultPostProcessor(modelPostProcessor);
        return this;
    }

    public ExtendedUnmarshaller<R, I> withEventLogging(Consumer<ValidationEvent> eventConsumer) throws JAXBException {
        ValidationEventHandler eventHandler = this.unmarshaller.getEventHandler();
        if (eventHandler instanceof InterceptEventHandler) {
            ((InterceptEventHandler)eventHandler).setEventConsumer(eventConsumer);
        } else {
            this.unmarshaller.setEventHandler((ValidationEventHandler)new InterceptEventHandler(eventConsumer, eventHandler));
        }
        return this;
    }

    public ExtendedUnmarshaller<R, I> withIdMapper(Class<I> classOfIdentifiableElements, Function<I, String> idMapper) {
        IdLookupGeneratorPostProcessor<I> idLookupGenerator = new IdLookupGeneratorPostProcessor<I>(classOfIdentifiableElements, idMapper);
        this.idLookupGenerators.add(idLookupGenerator);
        this.postProcessorRegistry.addDefaultPostProcessor(idLookupGenerator);
        return this;
    }

    public JaxbModel<R, I> unmarshall(InputStream resource) throws JAXBException {
        ModelPostProcessorManager modelPostProcessorManager = new ModelPostProcessorManager(this.postProcessorRegistry);
        this.unmarshaller.setListener((Unmarshaller.Listener)modelPostProcessorManager);
        R root = this.rootElement.cast(this.unmarshaller.unmarshal((Source)new SAXSource(this.getXMLReader(), new InputSource(resource))));
        modelPostProcessorManager.doPostProcessing();
        Optional<IdLookupProvider> idLookupProvider = this.idLookupGenerators.stream().map(IdLookupGeneratorPostProcessor::createIdLookkup).reduce(IdLookupProvider::merge);
        this.cleanUp();
        return new JaxbModel(root, idLookupProvider.orElse(null));
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    private void cleanUp() {
        this.unmarshaller.setListener(null);
        this.postProcessorRegistry.clearStateOfPostProcessors();
    }

    protected XMLReader getXMLReader() throws JAXBException {
        if (this.reader == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                this.reader = parser.getXMLReader();
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        return this.reader;
    }

    public static class InterceptEventHandler
    implements ValidationEventHandler {
        private final ValidationEventHandler originalEventHandler;
        private Consumer<ValidationEvent> eventConsumer;

        public InterceptEventHandler(Consumer<ValidationEvent> eventConsumer, ValidationEventHandler originalEventHandler) {
            Objects.requireNonNull(originalEventHandler);
            Objects.requireNonNull(eventConsumer);
            this.originalEventHandler = originalEventHandler;
            this.eventConsumer = eventConsumer;
        }

        public boolean handleEvent(ValidationEvent event) {
            this.eventConsumer.accept(event);
            return this.originalEventHandler.handleEvent(event);
        }

        public void setEventConsumer(Consumer<ValidationEvent> eventConsumer) {
            Objects.requireNonNull(eventConsumer);
            this.eventConsumer = eventConsumer;
        }
    }
}

