/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.read;

import com.foursoft.harness.navext.runtime.ExtendedUnmarshaller;
import com.foursoft.harness.navext.runtime.JaxbModel;
import com.foursoft.harness.navext.runtime.io.utils.ValidationEventLogger;
import com.foursoft.harness.navext.runtime.io.utils.XMLIOException;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.ValidationEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLReader<T, I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLReader.class);
    private final ExtendedUnmarshaller<T, I> unmarshaller;

    public XMLReader(Class<T> rootTypeClass, Class<I> identifiableClass, Function<I, String> idMapper) {
        this(rootTypeClass, identifiableClass, idMapper, new ValidationEventLogger());
    }

    public XMLReader(Class<T> rootTypeClass, Class<I> identifiableClass, Function<I, String> idMapper, Consumer<ValidationEvent> validationEventConsumer) {
        try {
            this.unmarshaller = new ExtendedUnmarshaller(rootTypeClass).withBackReferences().withIdMapper(identifiableClass, idMapper).withEventLogging(validationEventConsumer);
        }
        catch (Exception e) {
            throw new XMLIOException("Cannot initialize unmarshaller.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read(String filename) {
        Objects.requireNonNull(filename);
        Path path = Paths.get(filename, new String[0]).toAbsolutePath();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new XMLIOException("Given path: " + path + " doesn't exists.");
        }
        if (!Files.isReadable(path)) {
            throw new XMLIOException("Given path: " + path + " isn't readable.");
        }
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            T t = this.read(is);
            return t;
        }
        catch (IOException e) {
            throw new XMLIOException("Error reading file " + filename, e);
        }
    }

    public T read(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        return this.readModel(inputStream).getRootElement();
    }

    public JaxbModel<T, I> readModel(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        try {
            long start = System.currentTimeMillis();
            JaxbModel<T, I> result = this.unmarshaller.unmarshall(inputStream);
            LOGGER.trace("Finished loading XML. Took {} ms", (Object)(System.currentTimeMillis() - start));
            return result;
        }
        catch (JAXBException e) {
            throw new XMLIOException(e.getMessage(), e);
        }
    }
}

