/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.utils;

import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class LogEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogEvent.class);

    private LogEvent() {
    }

    public static String getLocationAndMessage(ValidationEvent event) {
        if (event == null) {
            return "";
        }
        return LogEvent.getLocation(event.getLocator()) + ": " + event.getMessage();
    }

    public static String getLocation(ValidationEventLocator locator) {
        if (locator == null) {
            return "";
        }
        return String.valueOf(locator.getLineNumber()) + ":" + locator.getColumnNumber() + " (" + LogEvent.getNodeId(locator) + ")";
    }

    public static void log(ValidationEvent event) {
        boolean warning;
        if (event == null) {
            return;
        }
        String locationAndMessage = LogEvent.getLocationAndMessage(event);
        boolean bl = warning = event.getSeverity() == 0;
        if (warning) {
            LOGGER.warn(locationAndMessage, event.getLinkedException());
        } else {
            LOGGER.error(locationAndMessage, event.getLinkedException());
        }
    }

    private static String getNodeId(ValidationEventLocator locator) {
        Node node = locator.getNode();
        if (node == null) {
            return "";
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return "";
        }
        Node id = attributes.getNamedItem("id");
        if (id == null) {
            return "";
        }
        return id.toString();
    }
}

