/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.validation;

import com.foursoft.harness.navext.runtime.io.validation.LogValidator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class LogErrors {
    private LogErrors() {
    }

    public static String annotateXMLContent(String xmlContent, Collection<LogValidator.ErrorLocation> errorLines) {
        if (errorLines.isEmpty()) {
            return xmlContent;
        }
        Map<Integer, String> errorMap = LogErrors.prepareErrors(errorLines);
        String[] lines = xmlContent.split("\\r?\\n");
        StringBuilder enhanced = new StringBuilder(xmlContent.length() * 2);
        for (int i = 1; i <= lines.length; ++i) {
            enhanced.append(i);
            enhanced.append(": ");
            if (errorMap.containsKey(i)) {
                enhanced.append("ERROR ");
            } else {
                enhanced.append("      ");
            }
            enhanced.append(lines[i - 1]);
            if (errorMap.containsKey(i)) {
                enhanced.append(' ');
                enhanced.append(errorMap.get(i));
            }
            enhanced.append('\n');
        }
        return enhanced.toString();
    }

    private static Map<Integer, String> prepareErrors(Collection<LogValidator.ErrorLocation> errorLines) {
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
        for (LogValidator.ErrorLocation errorLine : errorLines) {
            int line = errorLine.line;
            String error = errorLine.message;
            if (errorMap.containsKey(line)) {
                errorMap.put(line, (String)errorMap.get(line) + "/" + error);
                continue;
            }
            errorMap.put(line, error);
        }
        return errorMap;
    }
}

